/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.DynamicByteArray;
import edu.caltech.sbw.Receiver;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWRPC;
import java.io.IOException;

class RPCInCall
extends Thread {
    DataBlockReader reader;
    boolean transmitReply;
    SBWRPC rpc;
    Receiver receiver;
    boolean active = false;
    boolean operational = true;
    boolean callPending = false;
    static int threadNumber = 1;

    public RPCInCall(SBWRPC sBWRPC, Receiver receiver) {
        this.rpc = sBWRPC;
        this.receiver = receiver;
        SBWLog.trace("Spawning new message-handling thread for module " + sBWRPC.getModuleId());
        this.setDaemon(true);
        this.setName("rpcincall-thread-" + threadNumber);
        ++threadNumber;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (this.operational) {
            block17: {
                try {
                    if (!this.callPending && this.operational) {
                        this.wait();
                    }
                    if (!this.operational) {
                        --threadNumber;
                        return;
                    }
                    SBWLog.trace("Parsing new message");
                    this.callPending = false;
                    int n = this.reader.unpackIntegerWithoutType();
                    int n2 = this.reader.unpackIntegerWithoutType();
                    DataBlockWriter dataBlockWriter = null;
                    try {
                        int n3 = this.reader.unpackIntegerWithoutType();
                        int n4 = this.reader.unpackIntegerWithoutType();
                        SBWLog.trace("msg id = " + n + ", module = " + n2 + ", service = " + n3 + ", method = " + n4);
                        dataBlockWriter = this.doReceive(n2, n3, n4, this.reader);
                        if (this.transmitReply) {
                            this.rpc.transmit(n2, dataBlockWriter.createReply(n2, n));
                        }
                    }
                    catch (IOException iOException) {
                        SBWLog.trace("Stopping incoming call thread");
                        this.pleaseStop();
                    }
                    catch (Throwable throwable) {
                        if (this.transmitReply) {
                            SBWException sBWException = SBWException.translateException(throwable);
                            SBWLog.trace("Transmitting the following exception:");
                            SBWLog.trace(throwable);
                            DynamicByteArray dynamicByteArray = DataBlockWriter.createException(n2, n, sBWException.getCode(), sBWException.getMessage(), sBWException.getDetailedMessage());
                            try {
                                this.rpc.transmit(n2, dynamicByteArray);
                            }
                            catch (IOException iOException) {
                                SBWLog.trace("Stopping incoming call thread");
                                this.pleaseStop();
                            }
                            break block17;
                        }
                        SBWLog.error("Unexpected throw while processing msg", throwable);
                        --threadNumber;
                        throw throwable;
                    }
                    finally {
                        if (dataBlockWriter != null) {
                            dataBlockWriter.release();
                        }
                    }
                }
                catch (Throwable throwable) {
                    SBWLog.exception("While extracting data from incoming call", throwable);
                }
            }
            this.active = false;
        }
        --threadNumber;
    }

    public final DataBlockWriter doReceive(int n, int n2, int n3, DataBlockReader dataBlockReader) throws SBWException {
        if (n2 == -1) {
            switch (n3) {
                case 2: {
                    this.rpc.onOtherModuleInstanceShutdown(dataBlockReader, n);
                    return new DataBlockWriter();
                }
                case 5: {
                    this.rpc.onOtherModuleInstanceStartup(dataBlockReader, n);
                    return new DataBlockWriter();
                }
                case 6: {
                    this.rpc.onRegistrationChange(dataBlockReader, n);
                    return new DataBlockWriter();
                }
                case 3: {
                    this.rpc.onShutdown(dataBlockReader, n);
                    return new DataBlockWriter();
                }
            }
            return this.receiver.receive(n, n2, n3, dataBlockReader);
        }
        return this.receiver.receive(n, n2, n3, dataBlockReader);
    }

    public final boolean isActive() {
        return this.active;
    }

    public synchronized void execute(DataBlockReader dataBlockReader, boolean bl) {
        if (this.isActive()) {
            SBWLog.error("Attempted to execute incoming call in active call thread");
            return;
        }
        this.active = true;
        this.reader = dataBlockReader;
        this.transmitReply = bl;
        SBWLog.trace("Executing call, transmitReply = " + bl);
        this.callPending = true;
        this.notifyAll();
    }

    public synchronized void pleaseStop() {
        this.operational = false;
        this.notifyAll();
    }

    static {
        Config.recordClassVersion(RPCInCall.class, "$Id: RPCInCall.java,v 1.2 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

