/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.Sys;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

final class Proc {
    private OutputHandler stdOutputHandler;
    private OutputHandler errOutputHandler;
    private Process process;
    private boolean processAppearsStarted = false;

    public Proc(String string, String string2, int n) throws IOException, SecurityException {
        String[] stringArray = Proc.createExecCmdLine(string2);
        String string3 = "Starting " + string + " using:";
        for (int i = 0; i != stringArray.length; ++i) {
            string3 = string3 + " " + stringArray[i];
        }
        SBWLog.notice(string3);
        this.process = Runtime.getRuntime().exec(stringArray);
        this.stdOutputHandler = new OutputHandler(string + " stdout", this.process.getInputStream());
        this.errOutputHandler = new OutputHandler(string + " stderr", this.process.getErrorStream());
        this.stdOutputHandler.start();
        this.errOutputHandler.start();
        for (int i = n; i > 0; --i) {
            Sys.safeSleep(100);
            if (this.appearsRunning()) continue;
            SBWLog.notice("Process quit before end of startup wait");
            this.processAppearsStarted = false;
            return;
        }
        this.processAppearsStarted = true;
    }

    public final OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public final InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public final InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    public final int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public final int exitValue() {
        return this.process.exitValue();
    }

    public final void destroy() {
        this.process.destroy();
    }

    public final boolean appearsStarted() {
        return this.processAppearsStarted;
    }

    public final boolean appearsRunning() {
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        return false;
    }

    public static final boolean appearsRunning(Process process) {
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        return false;
    }

    private static String[] createExecCmdLine(String string) {
        String[] stringArray;
        switch (Sys.getOperatingSystem()) {
            default: {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                stringArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                break;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                stringArray = new String[]{"/bin/sh", "-c", string};
            }
        }
        return stringArray;
    }

    static class OutputHandler
    extends Thread {
        final InputStream inputStream;
        final String name;

        OutputHandler(String string, InputStream inputStream) {
            this.inputStream = inputStream;
            this.name = string;
            try {
                this.setDaemon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    SBWLog.notice(this.name + ": " + string);
                }
            }
            catch (IOException iOException) {
                SBWLog.warning("Problem reading subprocess " + this.name);
            }
        }
    }
}

