/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.BrokerInterface;
import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.Receiver;
import edu.caltech.sbw.SBWApplicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWMethodNotFoundException;
import edu.caltech.sbw.ServiceImpl;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

class ObjectOrientedReceiver
implements Receiver {
    private ArrayList services = new ArrayList(10);
    private int numServices = 0;
    private String moduleName;
    private int moduleId;

    public ObjectOrientedReceiver(String string) {
        this.moduleName = string;
    }

    public void addService(String string, String string2, String string3, Object object, String string4, Hashtable hashtable) {
        this.services.add(new ServiceImpl(string, string2, string3, object, string4, hashtable));
        this.numServices = this.services.size();
    }

    public void addService(Object object) {
        String string = object.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        this.services.add(new ServiceImpl(string, string, this.moduleName, object, "", new Hashtable()));
        this.numServices = this.services.size();
    }

    public final DataBlockWriter receive(int n, int n2, int n3, DataBlockReader dataBlockReader) throws SBWException {
        if (n2 == -1) {
            DataBlockWriter dataBlockWriter = new DataBlockWriter();
            try {
                switch (n3) {
                    case 0: {
                        dataBlockWriter.add(this.getServices());
                        return dataBlockWriter;
                    }
                    case 1: {
                        int n4 = dataBlockReader.getInt();
                        dataBlockWriter.add(this.getService(n4).getSignatureStrings());
                        return dataBlockWriter;
                    }
                    case 4: {
                        int n5 = dataBlockReader.getInt();
                        int n6 = dataBlockReader.getInt();
                        ServiceImpl serviceImpl = this.getService(n5);
                        String string = serviceImpl.getMethodHelp(n6);
                        if (string == null) {
                            string = new String("");
                        }
                        dataBlockWriter.add(string);
                        return dataBlockWriter;
                    }
                }
                throw new SBWMethodNotFoundException("Method " + n3 + " does not exist on service " + n2, "");
            }
            catch (Throwable throwable) {
                dataBlockWriter.release();
                throw SBWException.translateException(throwable);
            }
        }
        return this.getService(n2).invokeMethod(n, n3, dataBlockReader);
    }

    void registerServicesWithBroker(BrokerInterface brokerInterface) throws SBWException {
        for (ServiceImpl serviceImpl : this.services) {
            serviceImpl.registerWithBroker(brokerInterface, this.moduleName);
        }
    }

    void setModuleId(int n) {
        this.moduleId = n;
    }

    private final String[] getServices() {
        String[] stringArray = new String[this.services.size()];
        Iterator iterator = this.services.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ServiceImpl serviceImpl = (ServiceImpl)iterator.next();
            stringArray[n] = serviceImpl == null ? "" : serviceImpl.getServiceName();
            ++n;
        }
        return stringArray;
    }

    private final ServiceImpl getService(int n) throws SBWException {
        if (n < 0 || n >= this.numServices) {
            throw new SBWApplicationException("Unknown service id " + n, "");
        }
        ServiceImpl serviceImpl = (ServiceImpl)this.services.get(n);
        if (serviceImpl == null) {
            throw new SBWApplicationException("Service id " + n + " no longer supported", "The service identifier " + n + " is not known to this" + " module.  Either it is invalid or the module no longer" + "offers that service.");
        }
        return serviceImpl;
    }

    static {
        Config.recordClassVersion(ObjectOrientedReceiver.class, "$Id: ObjectOrientedReceiver.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

