/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.BrokerInterface;
import edu.caltech.sbw.Config;
import edu.caltech.sbw.ObjectOrientedReceiver;
import edu.caltech.sbw.SBW;
import edu.caltech.sbw.SBWBrokerStartException;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWIncorrectCategorySyntaxException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWLowLevelInternal;
import edu.caltech.sbw.SBWModuleDefinitionException;
import edu.caltech.sbw.SignatureScanner;
import edu.caltech.sbw.StringUtil;
import edu.caltech.sbw.Sys;
import grace.log.StackTrace;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ModuleImpl {
    public static final int UNIQUE = 0;
    public static final int SELF_MANAGED = 1;
    private static Hashtable savedMethodHelpStrings;
    private String moduleName;
    private String moduleDisplayName;
    private String cmdLine;
    private String helpString;
    private String host = "localhost";
    private int moduleType;
    private Class moduleMainClass;
    private ObjectOrientedReceiver receiver;

    public ModuleImpl(String string, String string2, int n, Class clazz, String string3) throws SBWModuleDefinitionException {
        this.initModuleImpl(string, string2, n, clazz, string3);
    }

    public ModuleImpl(String string, String string2, int n, Class clazz) throws SBWModuleDefinitionException {
        this.initModuleImpl(string, string2, n, clazz, "");
    }

    public ModuleImpl(String string, String string2, int n) throws SBWModuleDefinitionException {
        Class clazz = this.moduleClass();
        this.initModuleImpl(string, string2, n, clazz, "");
    }

    public ModuleImpl(String string) throws SBWModuleDefinitionException {
        String string2 = this.modulePackageName();
        Class clazz = this.moduleClass();
        this.initModuleImpl(string2, string, 1, clazz, "");
    }

    public void addService(String string, String string2, String string3, Class clazz, String string4, Hashtable hashtable) throws SBWIncorrectCategorySyntaxException, SBWModuleDefinitionException {
        if (clazz == null) {
            throw new SBWModuleDefinitionException("Null class supplied for service implementation", "The service implementation class must be non-null.");
        }
        try {
            this.addService(string, string2, string3, clazz.newInstance(), string4, hashtable);
        }
        catch (InstantiationException instantiationException) {
            String string5 = "Unable to instantiate Class object for service '" + string + "'";
            SBWLog.exception(string5, instantiationException);
            throw new SBWModuleDefinitionException(string5, "The class may be abstract, an interface, an array class, a primitive type, or void, or the instantiation may have failed for some other reason.");
        }
        catch (IllegalAccessException illegalAccessException) {
            String string6 = "Class or initializer for service '" + string + "' is not accessible";
            SBWLog.exception(string6, illegalAccessException);
            throw new SBWModuleDefinitionException(string6, "The class or initializer is not available.");
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            String string7 = "Failure during class initialization for service '" + string + "'";
            SBWLog.exception(string7, exceptionInInitializerError);
            throw new SBWModuleDefinitionException(string7, "The initialization provoked by this method failed.");
        }
        catch (SecurityException securityException) {
            String string8 = "No permission to create new instance of class for service '" + string + "'";
            SBWLog.exception(string8, securityException);
            throw new SBWModuleDefinitionException(string8, "Security exception.");
        }
    }

    public void addService(String string, String string2, String string3, Object object, String string4, Hashtable hashtable) throws SBWIncorrectCategorySyntaxException, SBWModuleDefinitionException {
        SBWLog.trace("Defining service on module '" + this.moduleName + "' named '" + string + "', display name '" + string2 + "', category '" + string3 + "'");
        if (StringUtil.empty(string)) {
            throw new SBWModuleDefinitionException("Null or empty service name", "Service names cannot be null or empty strings.");
        }
        if (!SignatureScanner.conformsToSName(string)) {
            throw new SBWModuleDefinitionException("Service identification name does not conform to allowable syntax", "Service identification names must begin with either a letter or an underscore character, followed by one or more letters, digits or underscore characters,  and contain at least one character or digit.");
        }
        if (StringUtil.empty(string2)) {
            throw new SBWModuleDefinitionException("Null or empty service display name", "Service display names cannot be null or empty strings.");
        }
        if (string3 == null) {
            throw new SBWIncorrectCategorySyntaxException("Null category given", "Category names cannot be null.");
        }
        if (object == null) {
            throw new SBWModuleDefinitionException("Null object supplied for service implementation", "The service implementation object must be non-null.");
        }
        this.receiver.addService(string, string2, string3, object, string4, hashtable);
    }

    public void addService(String string, String string2, String string3, Class clazz, String string4) throws SBWIncorrectCategorySyntaxException, SBWModuleDefinitionException {
        this.addService(string, string2, string3, clazz, "", savedMethodHelpStrings);
    }

    public void addService(String string, String string2, String string3, Object object, String string4) throws SBWIncorrectCategorySyntaxException, SBWModuleDefinitionException {
        this.addService(string, string2, string3, object, "", savedMethodHelpStrings);
    }

    public void addService(String string, String string2, String string3, Class clazz) throws SBWIncorrectCategorySyntaxException, SBWModuleDefinitionException {
        this.addService(string, string2, string3, clazz, "", savedMethodHelpStrings);
    }

    public void addService(String string, String string2, String string3, Object object) throws SBWIncorrectCategorySyntaxException, SBWModuleDefinitionException {
        this.addService(string, string2, string3, object, "", savedMethodHelpStrings);
    }

    public void addService(String string, String string2, Object object) throws SBWIncorrectCategorySyntaxException, SBWModuleDefinitionException {
        this.addService(string, string, string2, object, "", savedMethodHelpStrings);
    }

    public void addService(String string, String string2, Class clazz) throws SBWIncorrectCategorySyntaxException, SBWModuleDefinitionException {
        this.addService(string, string, string2, clazz, "", savedMethodHelpStrings);
    }

    public void registerModule() throws SBWModuleDefinitionException, SBWBrokerStartException, SBWCommunicationException {
        SBWLowLevelInternal sBWLowLevelInternal = SBW.getInternalAPI();
        sBWLowLevelInternal.connect(this.moduleName, "localhost");
        BrokerInterface brokerInterface = SBW.getBrokerService();
        try {
            brokerInterface.registerModule(this.moduleName, this.moduleDisplayName, this.moduleType, this.cmdLine, this.helpString);
            this.receiver.registerServicesWithBroker(brokerInterface);
        }
        catch (SBWModuleDefinitionException sBWModuleDefinitionException) {
            SBWLog.trace("Module definition exception", sBWModuleDefinitionException);
            throw sBWModuleDefinitionException;
        }
        catch (SBWException sBWException) {
            throw new SBWCommunicationException("Unable to register module with Broker", "");
        }
    }

    public void enableModuleServices() throws SBWCommunicationException, SBWBrokerStartException {
        SBWLowLevelInternal sBWLowLevelInternal = SBW.getInternalAPI();
        sBWLowLevelInternal.registerReceiver(this.receiver);
        sBWLowLevelInternal.connect(this.moduleName, this.host);
    }

    public void setCommandLine(String string) {
        this.cmdLine = string;
    }

    public String getCommandLine() {
        return this.cmdLine;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getHost() {
        return this.host;
    }

    public void run(String[] stringArray) throws SBWModuleDefinitionException, SBWCommunicationException, SBWBrokerStartException {
        if (Sys.OSIsMac() || Sys.OSIsUnix()) {
            System.setProperty("java.net.preferIPv4Stack", "true");
            System.setProperty("sbw.broker.allow-remote-modules", "true");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-sbwregister".equals(stringArray[i])) {
                SBWLog.trace("Registering module");
                this.registerModule();
                SBWLog.trace("Done.  Exiting.");
                System.exit(0);
                continue;
            }
            if (!"-sbwmodule".equals(stringArray[i])) continue;
            SBWLog.trace("Running as module");
            this.enableModuleServices();
            break;
        }
    }

    public static void setMethodHelp(String string, String string2) {
        if (savedMethodHelpStrings == null) {
            savedMethodHelpStrings = new Hashtable();
        }
        savedMethodHelpStrings.put(string, string2);
    }

    private void initModuleImpl(String string, String string2, int n, Class clazz, String string3) throws SBWModuleDefinitionException {
        if (StringUtil.empty(string)) {
            throw new SBWModuleDefinitionException("Null or empty module name", "Module names cannot be null or empty strings.");
        }
        if (string.indexOf(58) > 0) {
            throw new SBWModuleDefinitionException("The colon ':' character is not allowed in module names", "Module names cannot have a ':' character in them.  In SBW, the colon character separates host names from module names in contexts where remote modules may be specified. Colon characters are disallowed from module names to prevent ambiguity in those cases.");
        }
        if (StringUtil.empty(string2)) {
            throw new SBWModuleDefinitionException("Null or empty module display name", "Module display names cannot be null or empty strings.");
        }
        if (n != 0 && n != 1) {
            throw new SBWModuleDefinitionException("Invalid module type specified", "Module type must be one of ModuleImpl.SELF_MANAGED, ModuleImpl.SBW_MANAGED or ModuleImpl.UNIQUE");
        }
        if (clazz == null) {
            throw new SBWModuleDefinitionException("Null class supplied for module main class", "The module main class must be non-null.");
        }
        this.moduleName = string;
        this.moduleDisplayName = string2;
        this.moduleType = n;
        this.moduleMainClass = clazz;
        this.cmdLine = ModuleImpl.defaultCommandLine(clazz);
        this.helpString = string3;
        if (savedMethodHelpStrings != null) {
            savedMethodHelpStrings.clear();
        } else {
            savedMethodHelpStrings = new Hashtable();
        }
        this.receiver = new ObjectOrientedReceiver(string);
    }

    private String modulePackageName() {
        StackTrace stackTrace = new StackTrace(2 + Config.getStackDepthOffset());
        String string = stackTrace.getClassname();
        if (string.indexOf(46) > 0) {
            return string.substring(0, string.lastIndexOf(46));
        }
        return string;
    }

    private Class moduleClass() throws SBWModuleDefinitionException {
        StackTrace stackTrace = new StackTrace(2 + Config.getStackDepthOffset());
        String string = stackTrace.getClassname();
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            SBWLog.exception("Cannot recreate class " + string, classNotFoundException);
            throw new SBWModuleDefinitionException("Class " + string + " is inaccessible", "Should be able to create an instance of class " + string + ", but cannot");
        }
    }

    private static String defaultCommandLine(Class clazz) {
        String string = Config.getModuleOptions();
        String string2 = Sys.getJavaExecutable();
        if (string != null) {
            string2 = string2 + " ";
            string2 = string2 + string;
        }
        String string3 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
        string2 = Sys.OSIsWindows() ? string2 + " -Dsbw.user=\"%SBW_USER%\"" : string2 + " -Dsbw.user=\"$SBW_USER$\"";
        string2 = string2 + " -classpath \"";
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (!file.exists()) {
                SBWLog.error("Class path value '" + file + "' does not exist");
            } else if (!file.canRead()) {
                SBWLog.error("Class path value '" + file + "' is not readable");
            }
            if (file.canRead() && (file.isDirectory() || file.isFile())) {
                try {
                    string2 = string2 + file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = string2 + file.getPath();
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = string2 + File.pathSeparatorChar;
                continue;
            }
            SBWLog.error("Class path value '" + file + "'is not a file or directory");
        }
        string2 = string2 + "\" ";
        string2 = string2 + clazz.getName();
        string2 = string2 + " -sbwmodule";
        return string2;
    }

    static {
        Config.recordClassVersion(ModuleImpl.class, "$Id: ModuleImpl.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

