/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.BrokerInterface;
import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBW;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWModuleNotFoundException;
import edu.caltech.sbw.ServiceDescriptor;
import java.util.Hashtable;
import java.util.List;

public class ModuleDescriptor {
    private String name;
    private String displayName;
    private int moduleType;
    private String commandLine;
    private String helpString;
    private Hashtable services = new Hashtable(10);

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getManagementType() {
        return this.moduleType;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public String getHelp() {
        return this.helpString;
    }

    public ServiceDescriptor[] getServiceDescriptors() throws SBWCommunicationException {
        try {
            BrokerInterface brokerInterface = SBW.getBrokerService();
            List[] listArray = brokerInterface.getServiceDescriptors(this.name);
            ServiceDescriptor[] serviceDescriptorArray = new ServiceDescriptor[listArray.length];
            for (int i = 0; i < listArray.length; ++i) {
                serviceDescriptorArray[i] = new ServiceDescriptor(listArray[i]);
            }
            return serviceDescriptorArray;
        }
        catch (SBWModuleNotFoundException sBWModuleNotFoundException) {
            String string = "Module '" + this.name + "' no longer seems to exist";
            SBWLog.exception(string, sBWModuleNotFoundException);
            throw new SBWCommunicationException(string, sBWModuleNotFoundException.getDetailedMessage());
        }
        catch (SBWException sBWException) {
            String string = "Unable to get services descriptors for module '" + this.name + "'";
            SBWLog.exception(string, sBWException);
            throw new SBWCommunicationException(string, sBWException.getDetailedMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)object;
        return object instanceof ModuleDescriptor && this.name.equals(moduleDescriptor.getName()) && this.displayName.equals(moduleDescriptor.getDisplayName()) && this.moduleType == moduleDescriptor.getManagementType() && this.commandLine.equals(moduleDescriptor.getCommandLine()) && this.helpString.equals(moduleDescriptor.getHelp());
    }

    public ModuleDescriptor(String string, String string2, int n, String string3, String string4) {
        this.name = string;
        this.displayName = string2;
        this.moduleType = n;
        this.commandLine = string3;
        this.helpString = string4;
    }

    public ModuleDescriptor(List list) {
        Integer n = (Integer)list.get(2);
        this.name = (String)list.get(0);
        this.displayName = (String)list.get(1);
        this.moduleType = n;
        this.commandLine = (String)list.get(3);
        this.helpString = (String)list.get(4);
    }

    Hashtable getServices() {
        return this.services;
    }

    static {
        Config.recordClassVersion(ModuleDescriptor.class, "$Id: ModuleDescriptor.java,v 1.2 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

