/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.BrokerInterface;
import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.ModuleDescriptor;
import edu.caltech.sbw.SBW;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWLowLevelInternal;
import edu.caltech.sbw.SBWModuleNotFoundException;
import edu.caltech.sbw.Service;
import java.util.LinkedList;
import java.util.List;

public class Module {
    private int moduleId;
    private static SBWLowLevelInternal rpc = SBW.getInternalAPI();

    public ModuleDescriptor getDescriptor() throws SBWCommunicationException {
        try {
            BrokerInterface brokerInterface = SBW.getBrokerService();
            List list = brokerInterface.getModuleDescriptor(this.moduleId);
            return new ModuleDescriptor(list);
        }
        catch (SBWException sBWException) {
            String string = "Unable to get module descriptor from Broker";
            SBWLog.exception(string, sBWException);
            throw new SBWCommunicationException(string, sBWException.getMessage());
        }
    }

    public Service[] getServices() throws SBWCommunicationException {
        String[] stringArray = SBW.getServiceNamesFromModule(this.moduleId);
        Service[] serviceArray = new Service[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            serviceArray[i] = new Service(this.moduleId, i);
        }
        return serviceArray;
    }

    public Service findServiceByName(String string) throws SBWCommunicationException {
        String string2 = string.trim();
        String[] stringArray = SBW.getServiceNamesFromModule(this.moduleId);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return new Service(this.moduleId, i);
        }
        ModuleDescriptor moduleDescriptor = this.getDescriptor();
        throw new SBWCommunicationException("No service named '" + string2 + "' on module " + this.moduleId + " ('" + moduleDescriptor.getName() + "')", "");
    }

    public Service[] findServicesByCategory(String string) throws SBWCommunicationException {
        List[] listArray;
        Object object;
        try {
            object = SBW.getBrokerService();
            listArray = object.getServiceDescriptors(this.moduleId);
        }
        catch (SBWModuleNotFoundException sBWModuleNotFoundException) {
            SBWLog.exception(sBWModuleNotFoundException);
            throw new SBWCommunicationException("Module " + this.moduleId + " is no longer available", "");
        }
        catch (SBWException sBWException) {
            SBWLog.exception(sBWException);
            throw new SBWCommunicationException("Unable to get service descriptors from Broker", "");
        }
        object = new LinkedList();
        for (int i = 0; i < listArray.length; ++i) {
            String string2 = (String)listArray[i].get(3);
            if (!string2.equals(string) && (!string2.startsWith(string) || string2.charAt(string.length()) != '/')) continue;
            ((LinkedList)object).add(this.findServiceByName((String)listArray[i].get(1)));
        }
        return ((LinkedList)object).toArray(new Service[0]);
    }

    public void shutdown() throws SBWCommunicationException {
        SBWLog.trace("Issuing shutdown system call to module " + this.moduleId);
        DataBlockWriter dataBlockWriter = new DataBlockWriter();
        try {
            rpc.send(this.moduleId, -1, 3, dataBlockWriter);
        }
        catch (SBWException sBWException) {
            String string = "Unable to send shutdown to module " + this.moduleId;
            SBWLog.exception(string, sBWException);
            throw new SBWCommunicationException(string, sBWException.getDetailedMessage());
        }
        finally {
            dataBlockWriter.release();
        }
    }

    public boolean equals(Object object) {
        return object instanceof Module && ((Module)object).moduleId == this.moduleId;
    }

    Module(int n) {
        this.moduleId = n;
    }

    public int hashCode() {
        return this.moduleId;
    }

    static {
        Config.recordClassVersion(Module.class, "$Id: Module.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

