/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataPacker;
import edu.caltech.sbw.DynamicByteArray;

final class IntelPacker
implements DataPacker {
    IntelPacker() {
    }

    public void pack(int n, DynamicByteArray dynamicByteArray, int n2) {
        dynamicByteArray.add(n2, (byte)(n & 0xFF));
        dynamicByteArray.add(n2 + 1, (byte)((n & 0xFFFF) >>> 8));
        dynamicByteArray.add(n2 + 2, (byte)((n & 0xFFFFFF) >>> 16));
        dynamicByteArray.add(n2 + 3, (byte)(n >>> 24));
    }

    private void pack(long l, DynamicByteArray dynamicByteArray, int n) {
        dynamicByteArray.add(n, (byte)(l & 0xFFL));
        dynamicByteArray.add(n + 1, (byte)((l & 0xFFFFL) >>> 8));
        dynamicByteArray.add(n + 2, (byte)((l & 0xFFFFFFL) >>> 16));
        dynamicByteArray.add(n + 3, (byte)((l & 0xFFFFFFFFL) >>> 24));
        dynamicByteArray.add(n + 4, (byte)((l & 0xFFFFFFFFFFL) >>> 32));
        dynamicByteArray.add(n + 5, (byte)((l & 0xFFFFFFFFFFFFL) >>> 40));
        dynamicByteArray.add(n + 6, (byte)((l & 0xFFFFFFFFFFFFFFL) >>> 48));
        dynamicByteArray.add(n + 7, (byte)(l >>> 56));
    }

    public void pack(double d, DynamicByteArray dynamicByteArray, int n) {
        this.pack(Double.doubleToRawLongBits(d), dynamicByteArray, n);
    }

    public int unpackInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i != 32; i += 8) {
            n2 |= (0xFF & byArray[n]) << i;
            ++n;
        }
        return n2;
    }

    public long unpackLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i != 64; i += 8) {
            l |= (0xFFL & (long)byArray[n]) << i;
            ++n;
        }
        return l;
    }

    public double unpackDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(this.unpackLong(byArray, n));
    }

    static {
        Config.recordClassVersion(IntelPacker.class, "$Id: IntelPacker.java,v 1.3 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

