/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBWLog;
import java.util.LinkedList;
import java.util.ListIterator;

class DynamicByteArray {
    private static final int CHUNK_SIZE = 1000;
    private static final int POOL_SIZE = 10;
    private static LinkedList arrayPool = new LinkedList();
    private byte[] data = null;
    private int length = 0;

    public DynamicByteArray() {
        this.data = DynamicByteArray.getArrayFromPool(1000);
    }

    public DynamicByteArray(int n) {
        this.data = DynamicByteArray.getArrayFromPool(n);
    }

    public final void add(int n, byte by) {
        if (n >= this.data.length) {
            byte[] byArray = DynamicByteArray.getArrayFromPool(n * 2);
            byte[] byArray2 = this.data;
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
            DynamicByteArray.returnToPool(byArray2);
        }
        this.data[n] = by;
        if (n >= this.length) {
            this.length = n + 1;
        }
    }

    public final void replace(int n, byte by) {
        if (n >= this.data.length) {
            return;
        }
        this.data[n] = by;
    }

    public final byte get(int n) {
        return this.data[n];
    }

    public final void release() {
        DynamicByteArray.returnToPool(this.data);
        this.data = null;
        this.length = -1;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final int getLength() {
        return this.length;
    }

    public static final DynamicByteArray append(DynamicByteArray dynamicByteArray, int n, DynamicByteArray dynamicByteArray2, int n2) {
        DynamicByteArray dynamicByteArray3 = new DynamicByteArray(n + n2);
        System.arraycopy(dynamicByteArray.data, 0, dynamicByteArray3.data, 0, n);
        System.arraycopy(dynamicByteArray2.data, 0, dynamicByteArray3.data, n, n2);
        dynamicByteArray3.length = n + n2;
        return dynamicByteArray3;
    }

    public static final DynamicByteArray append(DynamicByteArray dynamicByteArray, int n, DynamicByteArray dynamicByteArray2, int n2, byte by) {
        DynamicByteArray dynamicByteArray3 = new DynamicByteArray(n + n2 + 1);
        System.arraycopy(dynamicByteArray.data, 0, dynamicByteArray3.data, 0, n);
        System.arraycopy(dynamicByteArray2.data, 0, dynamicByteArray3.data, n, n2);
        dynamicByteArray3.length = n + n2 + 1;
        dynamicByteArray3.data[dynamicByteArray3.length - 1] = by;
        return dynamicByteArray3;
    }

    public static final DynamicByteArray append(DynamicByteArray dynamicByteArray, int n, byte[] byArray, int n2, int n3) {
        DynamicByteArray dynamicByteArray2 = new DynamicByteArray(n + n2 - n3);
        System.arraycopy(dynamicByteArray.data, 0, dynamicByteArray2.data, 0, n);
        System.arraycopy(byArray, n3, dynamicByteArray2.data, n, n2 - n3);
        dynamicByteArray2.length = n + n2 - n3;
        return dynamicByteArray2;
    }

    public static final DynamicByteArray append(DynamicByteArray dynamicByteArray, int n, byte[] byArray, int n2, int n3, byte by) {
        DynamicByteArray dynamicByteArray2 = new DynamicByteArray(n + n2 - n3 + 1);
        System.arraycopy(dynamicByteArray.data, 0, dynamicByteArray2.data, 0, n);
        System.arraycopy(byArray, n3, dynamicByteArray2.data, n, n2 - n3);
        dynamicByteArray2.length = n + n2 - n3 + 1;
        dynamicByteArray2.data[dynamicByteArray2.length - 1] = by;
        return dynamicByteArray2;
    }

    private static final void checkPool() {
        ListIterator listIterator = arrayPool.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            byte[] byArray = (byte[])listIterator.next();
            int n2 = byArray.length;
            if (n2 < n) {
                SBWLog.error("Error in array pool.");
            }
            n = n2;
        }
        if (arrayPool.size() > 10) {
            SBWLog.error("Array pool too big.");
        }
    }

    private static final synchronized void returnToPool(byte[] byArray) {
        ListIterator<byte[]> listIterator = arrayPool.listIterator();
        while (listIterator.hasNext()) {
            byte[] byArray2 = (byte[])listIterator.next();
            if (byArray2.length < byArray.length) continue;
            listIterator.previous();
            listIterator.add(byArray);
            if (arrayPool.size() > 10) {
                arrayPool.removeFirst();
            }
            DynamicByteArray.checkPool();
            return;
        }
        arrayPool.addLast(byArray);
        if (arrayPool.size() > 10) {
            arrayPool.removeFirst();
        }
        DynamicByteArray.checkPool();
    }

    private static final synchronized byte[] getArrayFromPool(int n) {
        byte[] byArray = null;
        if (!arrayPool.isEmpty()) {
            byArray = (byte[])arrayPool.getLast();
        }
        if (byArray != null && byArray.length >= n) {
            arrayPool.removeLast();
            return byArray;
        }
        n = n < 1000 ? 1000 : n;
        return new byte[n];
    }

    static {
        Config.recordClassVersion(DynamicByteArray.class, "$Id: DynamicByteArray.java,v 1.3 2007/07/24 23:08:20 fbergmann Exp $");
    }
}

