/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataPacker;
import edu.caltech.sbw.DynamicByteArray;
import edu.caltech.sbw.IntelPacker;
import edu.caltech.sbw.SBWComplex;
import edu.caltech.sbw.SBWUnsupportedObjectTypeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class DataBlockWriter {
    static ArrayList typeNames = new ArrayList(11);
    public static final byte BYTE_TYPE = 0;
    public static final byte INTEGER_TYPE = 1;
    public static final byte DOUBLE_TYPE = 2;
    public static final byte BOOLEAN_TYPE = 3;
    public static final byte STRING_TYPE = 4;
    public static final byte ARRAY_TYPE = 5;
    public static final byte LIST_TYPE = 6;
    public static final byte VOID_TYPE = 7;
    public static final byte COMPLEX_TYPE = 8;
    static final byte TERMINATE_TYPE = -1;
    static final byte REPLY_CODE = 0;
    static final byte SEND_CODE = 1;
    static final byte CALL_CODE = 2;
    static final byte EXCEPTION_CODE = 3;
    static final int DISCONNECT_MESSAGE = -1;
    private DynamicByteArray data = null;
    private int end = 0;
    private static DataPacker packer;

    public DataBlockWriter() {
        this.data = new DynamicByteArray();
    }

    private DataBlockWriter(int n) {
        this.data = new DynamicByteArray(n);
    }

    public void add(byte by) {
        this.add(this.end, (byte)0);
        ++this.end;
        this.add(this.end, by);
        ++this.end;
    }

    public void add(boolean bl) {
        this.add(this.end, (byte)3);
        ++this.end;
        this.add(this.end, bl ? (byte)1 : 0);
        ++this.end;
    }

    public void add(int n) {
        this.add(this.end, (byte)1);
        ++this.end;
        this.packWithoutType(n);
    }

    void packWithoutType(int n) {
        packer.pack(n, this.data, this.end);
        this.end += 4;
    }

    private void packWithoutType(SBWComplex sBWComplex) {
        packer.pack(sBWComplex.getReal(), this.data, this.end);
        this.end += 8;
        packer.pack(sBWComplex.getImag(), this.data, this.end);
        this.end += 8;
    }

    private void packWithoutType(double d) {
        packer.pack(d, this.data, this.end);
        this.end += 8;
    }

    void packWithoutType(byte by) {
        this.add(this.end, by);
        ++this.end;
    }

    private void packWithoutType(String string) {
        packer.pack(string.length(), this.data, this.end);
        this.end += 4;
        byte[] byArray = string.getBytes();
        for (int i = 0; i != byArray.length; ++i) {
            this.add(this.end, byArray[i]);
            ++this.end;
        }
    }

    public void add(String string) {
        this.add(this.end, (byte)4);
        ++this.end;
        this.packWithoutType(string);
    }

    public void add(SBWComplex sBWComplex) {
        this.add(this.end, (byte)8);
        ++this.end;
        this.packWithoutType(sBWComplex);
    }

    public void add(double d) {
        this.add(this.end, (byte)2);
        ++this.end;
        this.packWithoutType(d);
    }

    public void add(Object object) throws SBWUnsupportedObjectTypeException {
        if (object == null) {
            throw new SBWUnsupportedObjectTypeException("Attempting to add null object to DataBlockWriter", "'null' is not an acceptable type of object to be added to a message data block.");
        }
        if (object instanceof String) {
            this.add((String)object);
        } else if (object instanceof Integer) {
            this.add((Integer)object);
        } else if (object instanceof Double) {
            this.add((Double)object);
        } else if (object instanceof SBWComplex) {
            this.add((SBWComplex)object);
        } else if (object instanceof Boolean) {
            this.add((Boolean)object);
        } else if (object instanceof Byte) {
            this.add((Byte)object);
        } else if (object instanceof List) {
            this.add((List)object);
        } else if (object instanceof int[]) {
            this.add((int[])object);
        } else if (object instanceof int[][]) {
            this.add((int[][])object);
        } else if (object instanceof boolean[]) {
            this.add((boolean[])object);
        } else if (object instanceof boolean[][]) {
            this.add((boolean[][])object);
        } else if (object instanceof byte[]) {
            this.add((byte[])object);
        } else if (object instanceof byte[][]) {
            this.add((byte[][])object);
        } else if (object instanceof double[]) {
            this.add((double[])object);
        } else if (object instanceof double[][]) {
            this.add((double[][])object);
        } else if (object instanceof String[]) {
            this.add((String[])object);
        } else if (object instanceof String[][]) {
            this.add((String[][])object);
        } else if (object instanceof SBWComplex[]) {
            this.add((SBWComplex[])object);
        } else if (object instanceof SBWComplex[][]) {
            this.add((SBWComplex[][])object);
        } else if (object instanceof List[]) {
            this.add((List[])object);
        } else if (object instanceof List[][]) {
            this.add((List[][])object);
        } else {
            throw new SBWUnsupportedObjectTypeException("Attempted to add object of unspported type '" + object.getClass().getName() + "' to message data block", "The type of object supplied as an argument to 'add' is not supported by SBW.  Please consult the SBW documentation for a list of allowable types.");
        }
    }

    private void packWithoutType(Collection collection) throws SBWUnsupportedObjectTypeException {
        packer.pack(collection.size(), this.data, this.end);
        this.end += 4;
        this.addOutOfCollection(collection);
    }

    public void addOutOfCollection(Collection collection) throws SBWUnsupportedObjectTypeException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void add(Collection collection) throws SBWUnsupportedObjectTypeException {
        this.add(this.end, (byte)6);
        ++this.end;
        this.packWithoutType(collection);
    }

    private void add1DArrayHeader(byte by, int n) {
        this.add(this.end, (byte)5);
        ++this.end;
        this.add(this.end, by);
        ++this.end;
        packer.pack(1, this.data, this.end);
        this.end += 4;
        packer.pack(n, this.data, this.end);
        this.end += 4;
    }

    private void add2DArrayHeader(byte by, int n, int n2) {
        this.add(this.end, (byte)5);
        ++this.end;
        this.add(this.end, by);
        ++this.end;
        packer.pack(2, this.data, this.end);
        this.end += 4;
        packer.pack(n, this.data, this.end);
        this.end += 4;
        packer.pack(n2, this.data, this.end);
        this.end += 4;
    }

    public void add(int[] nArray) {
        this.add1DArrayHeader((byte)1, nArray.length);
        for (int i = 0; i != nArray.length; ++i) {
            this.packWithoutType(nArray[i]);
        }
    }

    public void add(int[][] nArray) throws SBWUnsupportedObjectTypeException {
        this.add2DArrayHeader((byte)1, nArray.length, nArray[0].length);
        for (int i = 0; i != nArray.length; ++i) {
            if (nArray[i].length != nArray[0].length) {
                throw new SBWUnsupportedObjectTypeException("irregular array encountered. Only exactly rectangular 2D arrays are supported by SBW", "");
            }
            for (int j = 0; j != nArray[0].length; ++j) {
                this.packWithoutType(nArray[i][j]);
            }
        }
    }

    public void add(byte[] byArray) {
        this.add1DArrayHeader((byte)0, byArray.length);
        for (int i = 0; i != byArray.length; ++i) {
            this.add(this.end, byArray[i]);
            ++this.end;
        }
    }

    public void add(byte[][] byArray) throws SBWUnsupportedObjectTypeException {
        this.add2DArrayHeader((byte)0, byArray.length, byArray[0].length);
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i].length != byArray[0].length) {
                throw new SBWUnsupportedObjectTypeException("irregular array encountered. Only exactly rectangular 2D arrays are supported by SBW", "");
            }
            for (int j = 0; j != byArray[i].length; ++j) {
                this.add(this.end, byArray[i][j]);
                ++this.end;
            }
        }
    }

    public void add(boolean[] blArray) {
        this.add1DArrayHeader((byte)3, blArray.length);
        for (int i = 0; i != blArray.length; ++i) {
            this.add(this.end, blArray[i] ? (byte)1 : 0);
            ++this.end;
        }
    }

    public void add(boolean[][] blArray) throws SBWUnsupportedObjectTypeException {
        this.add2DArrayHeader((byte)3, blArray.length, blArray[0].length);
        for (int i = 0; i != blArray.length; ++i) {
            if (blArray[i].length != blArray[0].length) {
                throw new SBWUnsupportedObjectTypeException("irregular array encountered. Only exactly rectangular 2D arrays are supported by SBW", "");
            }
            for (int j = 0; j != blArray[i].length; ++j) {
                this.add(this.end, blArray[i][j] ? (byte)1 : 0);
                ++this.end;
            }
        }
    }

    public void add(String[] stringArray) {
        this.add1DArrayHeader((byte)4, stringArray.length);
        for (int i = 0; i != stringArray.length; ++i) {
            this.packWithoutType(stringArray[i]);
        }
    }

    public void add(String[][] stringArray) throws SBWUnsupportedObjectTypeException {
        this.add2DArrayHeader((byte)4, stringArray.length, stringArray[0].length);
        for (int i = 0; i != stringArray.length; ++i) {
            if (stringArray[i].length != stringArray[0].length) {
                throw new SBWUnsupportedObjectTypeException("irregular array encountered. Only exactly rectangular 2D arrays are supported by SBW", "");
            }
            for (int j = 0; j != stringArray[0].length; ++j) {
                this.packWithoutType(stringArray[i][j]);
            }
        }
    }

    public void add(SBWComplex[] sBWComplexArray) {
        this.add1DArrayHeader((byte)8, sBWComplexArray.length);
        for (int i = 0; i != sBWComplexArray.length; ++i) {
            this.packWithoutType(sBWComplexArray[i]);
        }
    }

    public void add(double[] dArray) {
        this.add1DArrayHeader((byte)2, dArray.length);
        for (int i = 0; i != dArray.length; ++i) {
            this.packWithoutType(dArray[i]);
        }
    }

    public void add(SBWComplex[][] sBWComplexArray) throws SBWUnsupportedObjectTypeException {
        this.add2DArrayHeader((byte)8, sBWComplexArray.length, sBWComplexArray[0].length);
        for (int i = 0; i != sBWComplexArray.length; ++i) {
            if (sBWComplexArray[i].length != sBWComplexArray[0].length) {
                throw new SBWUnsupportedObjectTypeException("irregular array encountered. Only exactly rectangular 2D arrays are supported by SBW", "");
            }
            for (int j = 0; j != sBWComplexArray[0].length; ++j) {
                this.packWithoutType(sBWComplexArray[i][j]);
            }
        }
    }

    public void add(double[][] dArray) throws SBWUnsupportedObjectTypeException {
        this.add2DArrayHeader((byte)2, dArray.length, dArray[0].length);
        for (int i = 0; i != dArray.length; ++i) {
            if (dArray[i].length != dArray[0].length) {
                throw new SBWUnsupportedObjectTypeException("irregular array encountered. Only exactly rectangular 2D arrays are supported by SBW", "");
            }
            for (int j = 0; j != dArray[0].length; ++j) {
                this.packWithoutType(dArray[i][j]);
            }
        }
    }

    public void add(Collection[] collectionArray) throws SBWUnsupportedObjectTypeException {
        this.add1DArrayHeader((byte)6, collectionArray.length);
        for (int i = 0; i != collectionArray.length; ++i) {
            this.packWithoutType(collectionArray[i]);
        }
    }

    public void add(Collection[][] collectionArray) throws SBWUnsupportedObjectTypeException {
        this.add2DArrayHeader((byte)6, collectionArray.length, collectionArray[0].length);
        for (int i = 0; i != collectionArray.length; ++i) {
            if (collectionArray[i].length != collectionArray[0].length) {
                throw new SBWUnsupportedObjectTypeException("irregular array encountered. Only exactly rectangular 2D arrays are supported by SBW", "");
            }
            for (int j = 0; j != collectionArray[0].length; ++j) {
                this.packWithoutType(collectionArray[i][j]);
            }
        }
    }

    private DynamicByteArray assembleMessage(DataBlockWriter dataBlockWriter) {
        DynamicByteArray dynamicByteArray = DynamicByteArray.append(dataBlockWriter.getData(), dataBlockWriter.end, this.getData(), this.end, (byte)-1);
        dataBlockWriter.release();
        return dynamicByteArray;
    }

    private DynamicByteArray assembleMessage(DataBlockWriter dataBlockWriter, byte[] byArray, int n) {
        DynamicByteArray dynamicByteArray = DynamicByteArray.append(dataBlockWriter.getData(), dataBlockWriter.end, byArray, byArray.length, n, (byte)-1);
        dataBlockWriter.release();
        return dynamicByteArray;
    }

    DynamicByteArray createReply(int n, int n2) {
        DataBlockWriter dataBlockWriter = new DataBlockWriter(13);
        dataBlockWriter.packWithoutType(this.data.getLength() + 14);
        dataBlockWriter.packWithoutType(n);
        dataBlockWriter.packWithoutType((byte)0);
        dataBlockWriter.packWithoutType(n2);
        return this.assembleMessage(dataBlockWriter);
    }

    private DynamicByteArray createInvoke(byte by, int n, int n2, int n3, int n4, int n5) {
        DataBlockWriter dataBlockWriter = new DataBlockWriter(25);
        dataBlockWriter.packWithoutType(this.data.getLength() + 26);
        dataBlockWriter.packWithoutType(n);
        dataBlockWriter.packWithoutType(by);
        dataBlockWriter.packWithoutType(n3);
        dataBlockWriter.packWithoutType(n2);
        dataBlockWriter.packWithoutType(n4);
        dataBlockWriter.packWithoutType(n5);
        return this.assembleMessage(dataBlockWriter);
    }

    DynamicByteArray createCall(int n, int n2, int n3, int n4, int n5) {
        return this.createInvoke((byte)2, n, n2, n3, n4, n5);
    }

    DynamicByteArray createSend(int n, int n2, int n3, int n4) {
        return this.createInvoke((byte)1, n, n2, -1, n3, n4);
    }

    static DynamicByteArray createException(int n, int n2, byte by, String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        DataBlockWriter dataBlockWriter = new DataBlockWriter();
        boolean bl = false;
        int n3 = 24 + string.length() + string2.length();
        dataBlockWriter.packWithoutType(n3);
        dataBlockWriter.packWithoutType(n);
        dataBlockWriter.packWithoutType((byte)3);
        dataBlockWriter.packWithoutType(n2);
        dataBlockWriter.packWithoutType(by);
        dataBlockWriter.add(string);
        dataBlockWriter.add(string2);
        return dataBlockWriter.getData();
    }

    static DynamicByteArray createDisconnectMessage() {
        DataBlockWriter dataBlockWriter = new DataBlockWriter(4);
        dataBlockWriter.packWithoutType(-1);
        return dataBlockWriter.getData();
    }

    static DynamicByteArray createConnectMessage(String string, String string2) {
        DataBlockWriter dataBlockWriter = new DataBlockWriter(4 + string.length() + string2.length());
        dataBlockWriter.packWithoutType(string);
        dataBlockWriter.packWithoutType(string2);
        return dataBlockWriter.getData();
    }

    static DynamicByteArray createConnectReply(int n) {
        DataBlockWriter dataBlockWriter = new DataBlockWriter(4);
        dataBlockWriter.packWithoutType(n);
        return dataBlockWriter.getData();
    }

    static DynamicByteArray createConnectReply(String string) {
        DataBlockWriter dataBlockWriter = new DataBlockWriter(string.length());
        dataBlockWriter.packWithoutType(string);
        return dataBlockWriter.getData();
    }

    static DynamicByteArray createReroutedMessage(int n, int n2, int n3, byte by, byte[] byArray, int n4, int n5) {
        DataBlockWriter dataBlockWriter = new DataBlockWriter(17);
        dataBlockWriter.packWithoutType(n5 - n4 + 17);
        dataBlockWriter.packWithoutType(n);
        dataBlockWriter.packWithoutType(by);
        dataBlockWriter.packWithoutType(n3);
        dataBlockWriter.packWithoutType(n2);
        DynamicByteArray dynamicByteArray = DynamicByteArray.append(dataBlockWriter.getData(), dataBlockWriter.end, byArray, n5, n4);
        dataBlockWriter.release();
        return dynamicByteArray;
    }

    DynamicByteArray getData() {
        return this.data;
    }

    public void release() {
        this.data.release();
    }

    private void add(int n, byte by) {
        this.data.add(n, by);
    }

    static String getTypeName(byte by) {
        return (String)typeNames.get(by);
    }

    static String getTypeName(int n) {
        return (String)typeNames.get(n);
    }

    static {
        typeNames.add(0, "byte");
        typeNames.add(1, "integer");
        typeNames.add(2, "double");
        typeNames.add(3, "boolean");
        typeNames.add(4, "string");
        typeNames.add(5, "array");
        typeNames.add(6, "list");
        typeNames.add(7, "void");
        typeNames.add(8, "complex");
        packer = new IntelPacker();
        Config.recordClassVersion(DataBlockWriter.class, "$Id: DataBlockWriter.java,v 1.3 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

