/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.DataPacker;
import edu.caltech.sbw.DynamicByteArray;
import edu.caltech.sbw.IntelPacker;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWComplex;
import edu.caltech.sbw.SBWTypeMismatchException;
import edu.caltech.sbw.SBWUnsupportedObjectTypeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class DataBlockReader {
    private byte[] data;
    private int current;
    private static DataPacker packer = new IntelPacker();

    DataBlockReader() {
        this.data = new byte[4];
        this.current = 0;
        this.data[0] = -1;
    }

    static byte[] read(InputStream inputStream, int n) throws IOException, SBWCommunicationException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            throw new SBWCommunicationException("End of file reached in input stream", "The other end of the socket connection likely has been disconnected, and attempts to read from the socket have failed.");
        }
        return byArray;
    }

    static int readInteger(InputStream inputStream) throws IOException, SBWCommunicationException {
        byte[] byArray = DataBlockReader.read(inputStream, 4);
        DataBlockReader dataBlockReader = new DataBlockReader(byArray);
        return dataBlockReader.unpackIntegerWithoutType();
    }

    static String readString(InputStream inputStream) throws IOException, SBWCommunicationException {
        byte[] byArray = DataBlockReader.read(inputStream, 4);
        DataBlockReader dataBlockReader = new DataBlockReader(byArray);
        int n = dataBlockReader.unpackIntegerWithoutType();
        byte[] byArray2 = DataBlockReader.read(inputStream, n);
        return new String(byArray2);
    }

    DataBlockReader(byte[] byArray) {
        this.data = byArray;
        this.current = 0;
    }

    DataBlockReader(DynamicByteArray dynamicByteArray) {
        this.data = dynamicByteArray.getData();
        this.current = 0;
    }

    private void unpackType(byte by) throws SBWTypeMismatchException {
        if (this.data[this.current] != by) {
            throw new SBWTypeMismatchException("Expecting " + DataBlockWriter.getTypeName(by) + ", instead found " + DataBlockWriter.getTypeName(this.data[this.current]) + " in datablock.", "");
        }
        ++this.current;
    }

    int unpackIntegerWithoutType() {
        int n = packer.unpackInt(this.data, this.current);
        this.current += 4;
        return n;
    }

    boolean unpackBooleanWithoutType() {
        boolean bl = this.data[this.current] != 0;
        ++this.current;
        return bl;
    }

    byte unpackByteWithoutType() {
        byte by = this.data[this.current];
        ++this.current;
        return by;
    }

    public int getInt() throws SBWTypeMismatchException {
        this.unpackType((byte)1);
        return this.unpackIntegerWithoutType();
    }

    public boolean getBoolean() throws SBWTypeMismatchException {
        this.unpackType((byte)3);
        return this.unpackBooleanWithoutType();
    }

    public byte getByte() throws SBWTypeMismatchException {
        this.unpackType((byte)0);
        return this.unpackByteWithoutType();
    }

    String unpackStringWithoutType() {
        int n = this.unpackIntegerWithoutType();
        String string = new String(this.data, this.current, n);
        this.current += n;
        return string;
    }

    public String getString() throws SBWTypeMismatchException {
        this.unpackType((byte)4);
        return this.unpackStringWithoutType();
    }

    private double unpackDoubleWithoutType() {
        double d = packer.unpackDouble(this.data, this.current);
        this.current += 8;
        return d;
    }

    private SBWComplex unpackComplexWithoutType() {
        double d = packer.unpackDouble(this.data, this.current);
        this.current += 8;
        double d2 = packer.unpackDouble(this.data, this.current);
        this.current += 8;
        return new SBWComplex(d, d2);
    }

    public SBWComplex getComplex() throws SBWTypeMismatchException {
        this.unpackType((byte)8);
        return this.unpackComplexWithoutType();
    }

    public double getDouble() throws SBWTypeMismatchException {
        this.unpackType((byte)2);
        return this.unpackDoubleWithoutType();
    }

    private Object unpackArrayWithoutType() throws SBWUnsupportedObjectTypeException, SBWTypeMismatchException {
        byte by = this.data[this.current];
        int n = packer.unpackInt(this.data, this.current + 1);
        --this.current;
        switch (by) {
            case 1: {
                switch (n) {
                    case 1: {
                        return this.get1DIntArray();
                    }
                    case 2: {
                        return this.get2DIntArray();
                    }
                }
                throw new SBWUnsupportedObjectTypeException("Found array with more than 2 dimensions in data block.  Not supported by reading library.", "");
            }
            case 3: {
                switch (n) {
                    case 1: {
                        return this.get1DBooleanArray();
                    }
                    case 2: {
                        return this.get2DBooleanArray();
                    }
                }
                throw new SBWUnsupportedObjectTypeException("Found array with more than 2 dimensions in data block.  Not supported by reading library.", "");
            }
            case 0: {
                switch (n) {
                    case 1: {
                        return this.get1DByteArray();
                    }
                    case 2: {
                        return this.get2DByteArray();
                    }
                }
                throw new SBWUnsupportedObjectTypeException("Found array with more than 2 dimensions in data block.  Not supported by reading library.", "");
            }
            case 8: {
                switch (n) {
                    case 1: {
                        return this.get1DComplexArray();
                    }
                    case 2: {
                        return this.get2DComplexArray();
                    }
                }
                throw new SBWUnsupportedObjectTypeException("Found array with more than 2 dimensions in data block.  Not supported by reading library.", "");
            }
            case 2: {
                switch (n) {
                    case 1: {
                        return this.get1DDoubleArray();
                    }
                    case 2: {
                        return this.get2DDoubleArray();
                    }
                }
                throw new SBWUnsupportedObjectTypeException("Found array with more than 2 dimensions in data block.  Not supported by reading library.", "");
            }
            case 4: {
                switch (n) {
                    case 1: {
                        return this.get1DStringArray();
                    }
                    case 2: {
                        return this.get2DStringArray();
                    }
                }
                throw new SBWUnsupportedObjectTypeException("Found array with more than 2 dimensions in data block.  Not supported by reading library.", "");
            }
            case 6: {
                switch (n) {
                    case 1: {
                        return this.get1DListArray();
                    }
                    case 2: {
                        return this.get2DListArray();
                    }
                }
                throw new SBWUnsupportedObjectTypeException("Found array with more than 2 dimensions in data block.  Not supported by reading library.", "");
            }
        }
        throw new SBWUnsupportedObjectTypeException("Found array of unknown type (" + by + ") in data block", "");
    }

    public Object getObject() throws SBWUnsupportedObjectTypeException, SBWTypeMismatchException {
        byte by = this.data[this.current];
        ++this.current;
        switch (by) {
            case 1: {
                return new Integer(this.unpackIntegerWithoutType());
            }
            case 3: {
                return new Boolean(this.unpackBooleanWithoutType());
            }
            case 0: {
                return new Byte(this.unpackByteWithoutType());
            }
            case 4: {
                return this.unpackStringWithoutType();
            }
            case 2: {
                return new Double(this.unpackDoubleWithoutType());
            }
            case 6: {
                return this.unpackListWithoutType();
            }
            case 8: {
                return new SBWComplex(this.unpackComplexWithoutType());
            }
            case 5: {
                return this.unpackArrayWithoutType();
            }
        }
        throw new SBWUnsupportedObjectTypeException("Unknown type (" + by + ") found in data block", "");
    }

    private List unpackListWithoutType() throws SBWUnsupportedObjectTypeException, SBWTypeMismatchException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = this.unpackIntegerWithoutType(); i != 0; --i) {
            linkedList.add(this.getObject());
        }
        return linkedList;
    }

    public Collection getIntoCollection() throws SBWUnsupportedObjectTypeException, SBWTypeMismatchException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (this.getNextType() != -1) {
            linkedList.add(this.getObject());
        }
        return linkedList;
    }

    public List getList() throws SBWUnsupportedObjectTypeException, SBWTypeMismatchException {
        this.unpackType((byte)6);
        return this.unpackListWithoutType();
    }

    private int unpackArrayHeader(int n, byte by) throws SBWTypeMismatchException {
        this.unpackType((byte)5);
        this.unpackType(by);
        int n2 = this.unpackIntegerWithoutType();
        if (n2 != n) {
            throw new SBWTypeMismatchException("Expecting array with " + n + ", instead found " + n2 + " dimensions.", "");
        }
        return this.unpackIntegerWithoutType();
    }

    public int[] get1DIntArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(1, (byte)1);
        int[] nArray = new int[n];
        for (int i = 0; i != n; ++i) {
            nArray[i] = this.unpackIntegerWithoutType();
        }
        return nArray;
    }

    public int[][] get2DIntArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(2, (byte)1);
        int n2 = this.unpackIntegerWithoutType();
        int[][] nArray = new int[n][n2];
        for (int i = 0; i != n; ++i) {
            for (int j = 0; j != n2; ++j) {
                nArray[i][j] = this.unpackIntegerWithoutType();
            }
        }
        return nArray;
    }

    public boolean[] get1DBooleanArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(1, (byte)3);
        boolean[] blArray = new boolean[n];
        for (int i = 0; i != n; ++i) {
            blArray[i] = this.unpackBooleanWithoutType();
        }
        return blArray;
    }

    public boolean[][] get2DBooleanArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(2, (byte)3);
        int n2 = this.unpackIntegerWithoutType();
        boolean[][] blArray = new boolean[n][n2];
        for (int i = 0; i != n; ++i) {
            for (int j = 0; j != n2; ++j) {
                blArray[i][j] = this.unpackBooleanWithoutType();
            }
        }
        return blArray;
    }

    public byte[] get1DByteArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(1, (byte)0);
        byte[] byArray = new byte[n];
        for (int i = 0; i != n; ++i) {
            byArray[i] = this.unpackByteWithoutType();
        }
        return byArray;
    }

    public byte[][] get2DByteArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(2, (byte)0);
        int n2 = this.unpackIntegerWithoutType();
        byte[][] byArray = new byte[n][n2];
        for (int i = 0; i != n; ++i) {
            for (int j = 0; j != n2; ++j) {
                byArray[i][j] = this.unpackByteWithoutType();
            }
        }
        return byArray;
    }

    public String[] get1DStringArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(1, (byte)4);
        String[] stringArray = new String[n];
        for (int i = 0; i != n; ++i) {
            stringArray[i] = this.unpackStringWithoutType();
        }
        return stringArray;
    }

    public String[][] get2DStringArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(2, (byte)4);
        int n2 = this.unpackIntegerWithoutType();
        String[][] stringArray = new String[n][n2];
        for (int i = 0; i != n; ++i) {
            for (int j = 0; j != n2; ++j) {
                stringArray[i][j] = this.unpackStringWithoutType();
            }
        }
        return stringArray;
    }

    public SBWComplex[] get1DComplexArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(1, (byte)8);
        SBWComplex[] sBWComplexArray = new SBWComplex[n];
        for (int i = 0; i != n; ++i) {
            sBWComplexArray[i] = this.unpackComplexWithoutType();
        }
        return sBWComplexArray;
    }

    public double[] get1DDoubleArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(1, (byte)2);
        double[] dArray = new double[n];
        for (int i = 0; i != n; ++i) {
            dArray[i] = this.unpackDoubleWithoutType();
        }
        return dArray;
    }

    public SBWComplex[][] get2DComplexArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(2, (byte)8);
        int n2 = this.unpackIntegerWithoutType();
        SBWComplex[][] sBWComplexArray = new SBWComplex[n][n2];
        for (int i = 0; i != n; ++i) {
            for (int j = 0; j != n2; ++j) {
                sBWComplexArray[i][j] = this.unpackComplexWithoutType();
            }
        }
        return sBWComplexArray;
    }

    public double[][] get2DDoubleArray() throws SBWTypeMismatchException {
        int n = this.unpackArrayHeader(2, (byte)2);
        int n2 = this.unpackIntegerWithoutType();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i != n; ++i) {
            for (int j = 0; j != n2; ++j) {
                dArray[i][j] = this.unpackDoubleWithoutType();
            }
        }
        return dArray;
    }

    public List[] get1DListArray() throws SBWUnsupportedObjectTypeException, SBWTypeMismatchException {
        int n = this.unpackArrayHeader(1, (byte)6);
        List[] listArray = new List[n];
        for (int i = 0; i != n; ++i) {
            listArray[i] = this.unpackListWithoutType();
        }
        return listArray;
    }

    public List[][] get2DListArray() throws SBWUnsupportedObjectTypeException, SBWTypeMismatchException {
        int n = this.unpackArrayHeader(2, (byte)6);
        int n2 = this.unpackIntegerWithoutType();
        List[][] listArray = new List[n][n2];
        for (int i = 0; i != n; ++i) {
            for (int j = 0; j != n2; ++j) {
                listArray[i][j] = this.unpackListWithoutType();
            }
        }
        return listArray;
    }

    public byte getNextType() {
        return this.data[this.current];
    }

    private void dumpObject() {
        try {
            switch (this.getNextType()) {
                case 4: {
                    System.out.print(this.getString());
                    break;
                }
                case 1: {
                    System.out.print(this.getInt());
                    break;
                }
                case 2: {
                    System.out.print(this.getDouble());
                    break;
                }
                case 8: {
                    SBWComplex sBWComplex = this.getComplex();
                    System.out.print("(" + sBWComplex.getReal() + ", " + sBWComplex.getImag() + "i)");
                    break;
                }
                case 5: {
                    ++this.current;
                    System.out.print(this.unpackArrayWithoutType());
                    break;
                }
                case 6: {
                    System.out.print(this.getList());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void dump(byte[] byArray) {
        if (byArray == null) {
            System.out.print("null");
        } else {
            DataBlockReader dataBlockReader = new DataBlockReader(byArray);
            while (dataBlockReader.getNextType() != -1) {
                dataBlockReader.dumpObject();
                System.out.print(" ");
            }
        }
        System.out.println();
    }

    static {
        Config.recordClassVersion(DataBlockReader.class, "$Id: DataBlockReader.java,v 1.3 2007/07/24 23:08:20 fbergmann Exp $");
    }
}

