/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.StringUtil;
import edu.caltech.sbw.Sys;
import edu.caltech.sbw.VerifiableFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

final class Config {
    private static Hashtable classVersionMap = new Hashtable();
    private static File sbwHome;
    private static VerifiableFile sbwUserDir;
    private static int moduleStartupWait;
    private static String brokerOptions;
    private static String moduleOptions;
    private static String brokerConnAccept;
    private static String brokerConnDeny;
    private static int stackDepthOffset;
    private static final String SBW_PROPERTIES_FILE = "config.properties";
    private static final String DEFAULT_WINDOWS_HOME = "c:\\Program Files\\KGI\\SBW\\bin";
    private static final String DEFAULT_UNIX_HOME;
    private static final String DEFAULT_MODULE_PORT_RANGE = "10002-10102";
    private static final String DEFAULT_BROKER_PORT_RANGE = "10102-10202";
    private static final int DEFAULT_BROKER_STARTUP_WAIT = 600;
    private static final int DEFAULT_MODULE_STARTUP_WAIT = 600;
    private static final String DEFAULT_REGISTRY_FILENAME = "sbwreg.xml";
    private static final String DEFAULT_UNIX_BROKER_STARTUP_SCRIPT = "startbroker";
    private static final String DEFAULT_WINDOWS_BROKER_STARTUP_SCRIPT = "brokerfile";
    private static final String DEFAULT_CORE_JARFILE = "SBWCore.jar";
    private static final String DEFAULT_CORE_DEBUG_JARFILE = "SBWCore-debug.jar";
    private static final String DEFAULT_BROKER_FILE = "Broker";
    private static final String DEFAULT_BROKER_DEBUG_FILE = "Brokerd";
    private static final String DEFAULT_WIN32_BROKER_FILE = "C++Broker";
    private static final String DEFAULT_WIN32_BROKER_DEBUG_FILE = "C++Brokerd";
    private static final String SBW_REGISTRY_CORE_KEY = "HKEY_CURRENT_USER\\SOFTWARE\\Systems Biology Workbench\\SBW Core";
    private static final String DEFAULT_LOG_FORMAT = "[%(clock)r %(%n)h (%e) %c.%f:%l] %m %o\n";
    private static final String DEFAULT_SSH_COMMAND = "ssh";
    private static final String DEFAULT_SSH_OPTIONS = "-T -e none -o BatchMode=yes -o CheckHostIP=no";
    private static final String DEFAULT_SSH_ASKPASS = "/usr/libexec/openssh/gnome-ssh-askpass";
    private static final String DEFAULT_USE_TUNNEL = "true";
    private static final String DEFAULT_TUNNEL_COMMAND = "ssh";
    private static final String DEFAULT_TUNNEL_OPTIONS = "-T -e none -o BatchMode=yes -o CheckHostIP=no";

    Config() {
    }

    static String getAPIVersion() {
        return "2.4.2";
    }

    public static Properties getEnvVars() {
        Process process = null;
        Properties properties = new Properties();
        try {
            Runtime runtime = Runtime.getRuntime();
            String string = System.getProperty("os.name").toLowerCase();
            process = string.indexOf("windows 9") > -1 ? runtime.exec("command.com /c set") : (string.indexOf("nt") > -1 || string.indexOf("windows 20") > -1 || string.indexOf("windows xp") > -1 ? runtime.exec("cmd.exe /c \"set SBW\"") : runtime.exec("env"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            for (int i = 0; i < 10000; ++i) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                int n = string2.indexOf(61);
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (string3 != null && string4 != null) {
                    properties.setProperty(string3, string4);
                }
                SBWLog.trace("adding environment variable: '" + string3 + "' with value '" + string4 + "'");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return properties;
    }

    static void printInfo() {
        System.out.println("SBW Java library version = " + Config.getAPIVersion());
        System.out.println("Host name = '" + Sys.getHostName() + "'");
        if (Sys.OSIsWindows()) {
            System.out.println("Running under a flavor of Windows");
        } else if (Sys.OSIsUnix()) {
            System.out.println("Running under a flavor of Unix/Linux");
        } else if (Sys.OSIsMac()) {
            System.out.println("Running under a flavor of MacOS");
        } else {
            System.out.println("Running under an unknown operating system");
        }
        System.out.println("System property values:");
        System.out.println("  Java VM                       = " + System.getProperty("java.vm.name") + ", version " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info"));
        System.out.println("  Java vendor                   = " + System.getProperty("java.vendor", "unknown"));
        System.out.println("  Java home                     = " + System.getProperty("java.home", "unknown"));
        System.out.println("  CLASSPATH                     = " + System.getProperty("java.class.path"));
        System.out.println("  User home                     = " + System.getProperty("user.home", "unknown"));
        System.out.println("  User directory                = " + System.getProperty("user.dir", "unknown"));
        System.out.println("SBW property values:");
        System.out.println("  sbw.home                        = " + System.getProperty("sbw.home"));
        System.out.println("  sbw.user.dir                    = " + System.getProperty("sbw.user.dir"));
        System.out.println("  sbw.key.file                    = " + System.getProperty("sbw.key.file"));
        System.out.println("  sbw.broker.allow-remote-modules = " + System.getProperty("sbw.broker.allow-remote-modules"));
        System.out.println("  sbw.broker.connections.accept   = " + System.getProperty("sbw.broker.connections.accept"));
        System.out.println("  sbw.broker.connections.deny     = " + System.getProperty("sbw.broker.connections.deny"));
        System.out.println("  sbw.broker.file              = " + System.getProperty("sbw.broker.file"));
        System.out.println("  sbw.broker.no-remote            = " + System.getProperty("sbw.broker.no-remote"));
        System.out.println("  sbw.broker.options              = " + System.getProperty("sbw.broker.options"));
        System.out.println("  sbw.broker.port.range           = " + System.getProperty("sbw.broker.port.range"));
        System.out.println("  sbw.broker.registry             = " + System.getProperty("sbw.broker.registry"));
        System.out.println("  sbw.broker.remote-from          = " + System.getProperty("sbw.broker.remote-from"));
        System.out.println("  sbw.broker.startup.script       = " + System.getProperty("sbw.broker.startup.script"));
        System.out.println("  sbw.broker.startup.wait         = " + System.getProperty("sbw.broker.startup.wait"));
        System.out.println("  sbw.broker.use-ssh              = " + System.getProperty("sbw.broker.use-ssh"));
        System.out.println("  sbw.module.options              = " + System.getProperty("sbw.module.options"));
        System.out.println("  sbw.module.port.range           = " + System.getProperty("sbw.module.port.range"));
        System.out.println("  sbw.module.startup.wait         = " + System.getProperty("sbw.module.startup.wait"));
        System.out.println("  sbw.ssh.askpass                 = " + System.getProperty("sbw.ssh.askpass"));
        System.out.println("  sbw.ssh.command                 = " + System.getProperty("sbw.ssh.command"));
        System.out.println("  sbw.ssh.options                 = " + System.getProperty("sbw.ssh.options"));
        System.out.println("  sbw.tunnel.command              = " + System.getProperty("sbw.tunnel.command"));
        System.out.println("  sbw.tunnel.options              = " + System.getProperty("sbw.tunnel.options"));
        System.out.println("  sbw.stack.depth.offset          = " + System.getProperty("sbw.stack.depth.offset"));
        System.out.println("Other settings:");
        System.out.println("  Effective sbw.user.dir: " + Config.getSBWUserDir());
        System.out.println("  Effective sbw.key.file: " + Config.getSessionKeyFile());
        System.out.println("  Runtime files directory: " + Config.getRuntimeFilesDirectory());
    }

    static void resetValues() {
        sbwUserDir = null;
        sbwUserDir = Config.getSBWUserDir();
        sbwHome = null;
        sbwHome = Config.getSBWHome();
    }

    static File getSBWHome() {
        VerifiableFile verifiableFile;
        Serializable serializable;
        if (sbwHome != null) {
            return sbwHome;
        }
        String string = Sys.getPropertyAsString("sbw.home");
        if (!StringUtil.empty(string)) {
            serializable = new VerifiableFile(string);
            if (((VerifiableFile)serializable).isVerifiedDirectory()) {
                sbwHome = serializable;
            } else {
                SBWLog.trace("sbw.home is not a directory -- ignoring it");
            }
        } else {
            SBWLog.trace("sbw.home property not set; looking in config props");
        }
        serializable = Config.getConfigProperties();
        if (serializable != null && !StringUtil.empty(string = ((Properties)serializable).getProperty("sbw.home")) && (verifiableFile = new VerifiableFile(string)).isVerifiedDirectory()) {
            SBWLog.trace("sbw.home set in config file to " + verifiableFile.getPath());
            sbwHome = verifiableFile;
            return sbwHome;
        }
        if (Sys.OSIsWindows()) {
            SBWLog.trace("Can't get sbw.home from config file; looking in /WINNT/system32");
            sbwHome = Config.getSBWHomeFromWindowsProperties();
            return sbwHome;
        }
        return null;
    }

    private static Properties getConfigProperties() {
        File file = Config.getConfigPropertiesFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            SBWLog.trace("Reading config properties from " + file.getPath());
            Properties properties = new Properties();
            properties.load(fileInputStream);
            return properties;
        }
        catch (FileNotFoundException fileNotFoundException) {
            SBWLog.notice("Config properties file '" + file.getPath() + "' does not exist.");
        }
        catch (IOException iOException) {
            SBWLog.warning("I/O problem reading '" + file.getPath());
        }
        catch (SecurityException securityException) {
            SBWLog.warning("Security manager prevents access to " + file.getPath());
        }
        return null;
    }

    private static File getConfigPropertiesFile() {
        VerifiableFile verifiableFile = Config.getSBWUserDir();
        if (verifiableFile == null || !verifiableFile.isVerifiedDirectory()) {
            SBWLog.trace("Cannot access user dir -- no config file");
            return null;
        }
        return new VerifiableFile(verifiableFile, SBW_PROPERTIES_FILE);
    }

    private static File getSBWHomeFromWindowsProperties() {
        VerifiableFile verifiableFile;
        Object object;
        VerifiableFile verifiableFile2 = Sys.getWindowsSystemDirectory();
        if (!verifiableFile2.isVerifiedDirectory()) {
            SBWLog.warning("System directory " + verifiableFile2.getPath() + " does not exist or is inaccessible");
            return null;
        }
        SBWLog.trace("Directory '" + verifiableFile2.getPath() + "' exists");
        Properties properties = new Properties();
        File file = new File(verifiableFile2, SBW_PROPERTIES_FILE);
        try {
            object = new FileInputStream(file);
            properties.load((InputStream)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            SBWLog.warning("SBW properties file '" + file.getPath() + "' does not exist.");
            return null;
        }
        catch (IOException iOException) {
            SBWLog.warning("I/O problem reading '" + file.getPath());
            return null;
        }
        catch (SecurityException securityException) {
            SBWLog.warning("Security manager prevents access to " + file.getPath());
            return null;
        }
        object = properties.getProperty("sbw.home");
        if (object != null && (verifiableFile = new VerifiableFile((String)object)).isVerifiedDirectory()) {
            SBWLog.trace("Found sbw.home in " + file.getPath());
            return verifiableFile;
        }
        SBWLog.trace("Could not find sbw.home in " + file.getPath());
        return null;
    }

    static VerifiableFile getRuntimeFilesDirectory() {
        String string = Config.getSBWUserDir() + File.separator + "runtime" + File.separator + "127.0.0.1";
        return new VerifiableFile(string);
    }

    static VerifiableFile getSessionKeyFile() {
        String string = System.getProperty("sbw.key.file");
        if (!StringUtil.empty(string)) {
            return new VerifiableFile(string, "key");
        }
        return new VerifiableFile(Config.getRuntimeFilesDirectory(), "key");
    }

    static File getBrokerStartupScript() {
        VerifiableFile verifiableFile;
        String string = Sys.getPropertyAsString("sbw.broker.startup.script");
        if (!StringUtil.empty(string)) {
            verifiableFile = new VerifiableFile(string);
            if (verifiableFile.isVerifiedExistingFile()) {
                return verifiableFile;
            }
            SBWLog.trace("sbw.broker.startup.script is not a file -- ignoring it");
        } else {
            SBWLog.trace("sbw.broker.startup.script property not set; using defaults");
        }
        verifiableFile = Config.getSBWUserDir();
        if (verifiableFile != null && verifiableFile.isVerifiedDirectory()) {
            verifiableFile = Sys.OSIsWindows() ? new VerifiableFile(verifiableFile, DEFAULT_WINDOWS_BROKER_STARTUP_SCRIPT) : new VerifiableFile(verifiableFile, DEFAULT_UNIX_BROKER_STARTUP_SCRIPT);
            if (verifiableFile.isVerifiedExistingFile()) {
                return verifiableFile;
            }
            SBWLog.trace(verifiableFile.getPath() + " does not exist");
        } else {
            SBWLog.trace("SBW bin dir not found: " + verifiableFile.getPath());
        }
        return null;
    }

    static File getBrokerFile() {
        File file = Config.getBrokerFromProperty();
        if (file != null) {
            return file;
        }
        file = Config.getBrokerFromSBWHome();
        if (file != null) {
            return file;
        }
        file = Config.getBrokerFromCurrentDirectory();
        if (file != null) {
            return file;
        }
        file = Config.getBrokerFromDefaults();
        if (file != null) {
            return file;
        }
        SBWLog.error("Unable to locate SBW Broker file.");
        return null;
    }

    private static File getBrokerFromProperty() {
        String string = Sys.getPropertyAsString("sbw.broker.file");
        if (string != null) {
            File file = new File(string);
            if (!file.exists()) {
                SBWLog.warning("File named by sbw.broker.file does not exist");
            } else if (!file.canRead()) {
                SBWLog.warning("File named by sbw.broker.file is not readable");
            } else if (!file.isFile()) {
                SBWLog.warning("File named by sbw.broker.file is not a file");
            } else {
                return file;
            }
        }
        SBWLog.trace("Broker not found from sbw.broker.file property");
        return null;
    }

    private static File getBrokerFromSBWHome() {
        File file = Config.getSBWHome();
        if (file != null) {
            return Config.checkBrokersInPath(file.getPath() + File.separatorChar + "bin");
        }
        SBWLog.trace("Broker not found from sbw.home property");
        return null;
    }

    private static File findBrokerFromLoadedFile(String string) {
        File file = new File(string.substring(5));
        VerifiableFile verifiableFile = new VerifiableFile(file.getParentFile(), DEFAULT_BROKER_FILE);
        if (verifiableFile.isVerifiedExistingFile()) {
            SBWLog.trace("Using Broker " + verifiableFile.getPath());
            return verifiableFile;
        }
        SBWLog.trace("Class loader says we're loaded from " + string);
        SBWLog.trace("but Broker is not in the directory");
        return null;
    }

    private static File getBrokerFromCurrentDirectory() {
        return Config.checkBrokersInPath(System.getProperty("user.dir"));
    }

    private static File getBrokerFromDefaults() {
        return Config.checkBrokersInPath(Config.getDefaultSBWHome().getPath() + File.separator + "bin");
    }

    private static VerifiableFile findOnClassPath(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.endsWith(string2)) {
                VerifiableFile verifiableFile = new VerifiableFile(string4);
                SBWLog.trace("Found " + string4 + " on class path");
                return verifiableFile;
            }
            if (!string4.endsWith(string3)) continue;
            VerifiableFile verifiableFile = new VerifiableFile(string4);
            SBWLog.trace("Found " + string4 + " on class path");
            return verifiableFile;
        }
        return null;
    }

    private static VerifiableFile checkBrokersInPath(String string) {
        if (string == null) {
            return null;
        }
        VerifiableFile verifiableFile = new VerifiableFile(string, DEFAULT_BROKER_FILE);
        if (verifiableFile.isVerifiedExistingFile()) {
            SBWLog.trace("Found Broker in " + string);
            return verifiableFile;
        }
        verifiableFile = new VerifiableFile(string, DEFAULT_BROKER_DEBUG_FILE);
        if (verifiableFile.isVerifiedExistingFile()) {
            SBWLog.trace("Found Brokerd in " + string);
            return verifiableFile;
        }
        verifiableFile = new VerifiableFile(string, DEFAULT_WIN32_BROKER_FILE);
        if (verifiableFile.isVerifiedExistingFile()) {
            SBWLog.trace("Found C++Broker in " + string);
            return verifiableFile;
        }
        verifiableFile = new VerifiableFile(string, DEFAULT_WIN32_BROKER_DEBUG_FILE);
        if (verifiableFile.isVerifiedExistingFile()) {
            SBWLog.trace("Found C++Brokerd in " + string);
            return verifiableFile;
        }
        SBWLog.trace("Broker not found from path '" + string + "'");
        return null;
    }

    static VerifiableFile getSBWUserDir() {
        VerifiableFile verifiableFile;
        if (sbwUserDir != null) {
            return sbwUserDir;
        }
        Properties properties = Config.getEnvVars();
        String string = properties.getProperty("SBW_USER");
        if (!StringUtil.empty(string)) {
            verifiableFile = new VerifiableFile(string);
            if (verifiableFile.isVerifiedDirectory()) {
                sbwUserDir = verifiableFile;
                return sbwUserDir;
            }
            SBWLog.trace("SBW_USER is not a directory -- ignoring it");
        } else {
            SBWLog.trace("SBW_USER environment variable not set; looking in config props");
        }
        string = System.getProperty("sbw.user");
        if (!StringUtil.empty(string)) {
            verifiableFile = new VerifiableFile(string);
            if (verifiableFile.isVerifiedDirectory()) {
                sbwUserDir = verifiableFile;
                return sbwUserDir;
            }
            SBWLog.trace("sbw.user is not a directory -- ignoring it");
        } else {
            SBWLog.trace("sbw.user property not set; looking in config props");
        }
        string = Sys.getPropertyAsString("sbw.user.dir");
        if (!StringUtil.empty(string)) {
            verifiableFile = new VerifiableFile(string);
            if (verifiableFile.isVerifiedFile()) {
                SBWLog.warning("Path given by sbw.user.dir is a file; should be a directory");
            } else {
                sbwUserDir = verifiableFile;
            }
        }
        if (sbwUserDir == null) {
            sbwUserDir = new VerifiableFile(System.getProperty("user.home"), ".sbw");
        }
        if (!sbwUserDir.exists()) {
            try {
                SBWLog.notice("Creating directory '" + sbwUserDir + "'");
                if (!sbwUserDir.mkdir()) {
                    SBWLog.warning("Unable to create directory '" + sbwUserDir + "'");
                }
            }
            catch (SecurityException securityException) {
                SBWLog.warning("Java security prevents creation of directory '" + sbwUserDir + "'");
                return null;
            }
        }
        return sbwUserDir;
    }

    static File getBrokerRegistryFile() {
        String string = Sys.getPropertyAsString("sbw.broker.registry");
        if (!StringUtil.empty(string)) {
            return new File(string);
        }
        SBWLog.trace("sbw.broker.registry property not set; using defaults");
        VerifiableFile verifiableFile = Config.getSBWUserDir();
        if (verifiableFile != null) {
            return new File(verifiableFile, DEFAULT_REGISTRY_FILENAME);
        }
        SBWLog.trace("No user directory, hence no registry file");
        return null;
    }

    static boolean allowRemoteBrokers() {
        return "false".equals(System.getProperty("sbw.broker.no-remote", "false"));
    }

    static int[] getBrokerPortRange() {
        String string = System.getProperty("sbw.broker.port.range", DEFAULT_BROKER_PORT_RANGE);
        int[] nArray = StringUtil.parseRange(string);
        if (nArray.length != 2) {
            SBWLog.trace("Bad value for sbw.broker.port.range: " + string);
            nArray = StringUtil.parseRange(DEFAULT_BROKER_PORT_RANGE);
        }
        return nArray;
    }

    static int[] getModulePortRange() {
        String string = System.getProperty("sbw.module.port.range", DEFAULT_MODULE_PORT_RANGE);
        int[] nArray = StringUtil.parseRange(string);
        if (nArray.length != 2) {
            SBWLog.trace("Bad value for sbw.broker.port.range: " + string);
            nArray = StringUtil.parseRange(DEFAULT_BROKER_PORT_RANGE);
        }
        return nArray;
    }

    static int getBrokerStartupWait() {
        return Sys.getPropertyAsInt("sbw.broker.startup.wait", 600);
    }

    static int getModuleStartupWait() {
        return Sys.getPropertyAsInt("sbw.module.startup.wait", 600);
    }

    static String getBrokerOptions() {
        int[] nArray = Sys.getJavaVersion();
        String string = System.getProperty("sbw.broker.options");
        if (!StringUtil.empty(string)) {
            return string;
        }
        return "";
    }

    static String getModuleOptions() {
        return Sys.getPropertyAsString("sbw.module.options");
    }

    static boolean useSSH() {
        return DEFAULT_USE_TUNNEL.equals(System.getProperty("sbw.broker.use-ssh", DEFAULT_USE_TUNNEL));
    }

    static String getSSHCommand() {
        return Sys.getPropertyAsString("sbw.ssh.command", "ssh");
    }

    static String getSSHOptions() {
        return Sys.getPropertyAsString("sbw.ssh.options", "-T -e none -o BatchMode=yes -o CheckHostIP=no");
    }

    static String getSSHAskPass() {
        return Sys.getPropertyAsString("sbw.ssh.askpass", DEFAULT_SSH_ASKPASS);
    }

    static boolean allowRemoteModules() {
        return DEFAULT_USE_TUNNEL.equals(System.getProperty("sbw.broker.allow-remote-modules", "false"));
    }

    static String getTunnelCommand() {
        return Sys.getPropertyAsString("sbw.tunnel.command", "ssh");
    }

    static String getTunnelOptions() {
        return Sys.getPropertyAsString("sbw.tunnel.options", "-T -e none -o BatchMode=yes -o CheckHostIP=no");
    }

    static int getStackDepthOffset() {
        return stackDepthOffset;
    }

    static String getBrokerConnectionsAccept() {
        return Sys.getPropertyAsString("sbw.broker.connections.accept");
    }

    static String getBrokerConnectionsDeny() {
        return Sys.getPropertyAsString("sbw.broker.connections.deny");
    }

    static void recordClassVersion(Class clazz, String string) {
        classVersionMap.put(clazz, string);
    }

    static Iterator classes() {
        return classVersionMap.keySet().iterator();
    }

    static String classInfo(Class clazz) {
        return (String)classVersionMap.get(clazz);
    }

    static void printClassVersions() {
        Iterator iterator = Config.classes();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            System.out.println(clazz + ": " + Config.classInfo(clazz));
        }
    }

    private static File getDefaultSBWHome() {
        if (Sys.OSIsWindows()) {
            return new File(DEFAULT_WINDOWS_HOME);
        }
        if (Sys.OSIsUnix() || Sys.OSIsMac()) {
            return new File(DEFAULT_UNIX_HOME);
        }
        SBWLog.warning("Support for this OS not yet implemented");
        return null;
    }

    static {
        stackDepthOffset = 0;
        DEFAULT_UNIX_HOME = System.getProperty("user.home") + "/SBW";
        Integer n = Sys.getPropertyAsInt("sbw.stack.depth.offset");
        if (n != null) {
            stackDepthOffset = n;
        }
        System.setProperty("log.format", DEFAULT_LOG_FORMAT);
        if (System.getProperty("log") == null) {
            System.setProperty("log", "false");
        }
        Config.recordClassVersion(Config.class, "$Id: Config.java,v 1.3 2007/07/24 23:08:20 fbergmann Exp $");
    }
}

