/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.color;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import javax.swing.plaf.UIResource;

public class InactivatableColorUIResource
extends Color
implements UIResource {
    private boolean isActive;
    private boolean isTransparent;
    private int inactiveRGB;

    public InactivatableColorUIResource(int activeRGB, int inactiveRGB) {
        super(activeRGB);
        this.inactiveRGB = inactiveRGB | 0xFF000000;
    }

    public InactivatableColorUIResource(int activeRGB, int inactiveRGB, boolean hasAlpha) {
        super(activeRGB, hasAlpha);
        this.inactiveRGB = hasAlpha ? inactiveRGB : inactiveRGB | 0xFF000000;
    }

    public void setActive(boolean newValue) {
        this.isActive = newValue;
    }

    public void setTransparent(boolean newValue) {
        this.isTransparent = newValue;
    }

    public int getTransparency() {
        return this.isTransparent ? 3 : super.getTransparency();
    }

    public int getAlpha() {
        return this.isTransparent ? 0 : super.getAlpha();
    }

    public int getRGB() {
        return this.isTransparent ? 0 : (this.isActive ? super.getRGB() : this.inactiveRGB);
    }

    public PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        return this.isActive ? super.createContext(cm, r, r2d, xform, hints) : new Color(this.inactiveRGB, true).createContext(cm, r, r2d, xform, hints);
    }
}

