/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.webtools;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebFile {
    public static final String DEFAULT_CHARSET_ENCODING = "UTF-8";
    private Map<String, List<String>> responseHeader = null;
    private URL responseURL = null;
    private int responseCode = -1;
    private String MIMEtype = null;
    private String charset = "UTF-8";
    private Object content = null;

    public WebFile(String string) throws MalformedURLException, IOException {
        String[] stringArray;
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("URL protocol must be HTTP.");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(10000);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setRequestProperty("User-agent", "jlibsedml");
        httpURLConnection.connect();
        this.responseHeader = httpURLConnection.getHeaderFields();
        this.responseCode = httpURLConnection.getResponseCode();
        this.responseURL = httpURLConnection.getURL();
        int n = httpURLConnection.getContentLength();
        String string2 = httpURLConnection.getContentType();
        if (string2 != null) {
            stringArray = string2.split(";");
            this.MIMEtype = stringArray[0].trim();
            for (int i = 1; i < stringArray.length && this.charset == null; ++i) {
                String string3 = stringArray[i].trim();
                int n2 = string3.toLowerCase().indexOf("charset=");
                if (n2 == -1) continue;
                this.charset = string3.substring(n2 + 8);
            }
        }
        if ((stringArray = httpURLConnection.getErrorStream()) != null) {
            this.content = this.readStream(n, (InputStream)stringArray);
        } else {
            this.content = httpURLConnection.getContent();
            if (this.content != null && this.content instanceof InputStream) {
                this.content = this.readStream(n, (InputStream)this.content);
            }
        }
        httpURLConnection.disconnect();
    }

    private Object readStream(int n, InputStream inputStream) throws IOException {
        int n2 = Math.max(1024, Math.max(n, inputStream.available()));
        byte[] byArray = new byte[n2];
        byte[] byArray2 = null;
        int n3 = inputStream.read(byArray);
        while (n3 != -1) {
            if (byArray2 == null) {
                byArray2 = byArray;
                byArray = new byte[n2];
            } else {
                byte[] byArray3 = new byte[byArray2.length + n3];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray, 0, byArray3, byArray2.length, n3);
                byArray2 = byArray3;
            }
            n3 = inputStream.read(byArray);
        }
        if (this.charset == null) {
            return byArray2;
        }
        try {
            return new String(byArray2, this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return byArray2;
        }
    }

    public Object getContent() {
        return this.content;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.responseHeader;
    }

    public URL getURL() {
        return this.responseURL;
    }

    public String getMIMEType() {
        return this.MIMEtype;
    }
}

