/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.sedml.Model;
import org.sedml.SedMLError;
import org.sedml.validation.ISedMLValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIValidator
implements ISedMLValidator {
    private List<Model> models;
    public static final String ErrMessageRoot = "Could not convert model source to URI";

    URIValidator(List<Model> list) {
        this.models = list;
    }

    @Override
    public List<SedMLError> validate() {
        ArrayList<SedMLError> arrayList = new ArrayList<SedMLError>();
        for (Model model : this.models) {
            try {
                URI uRI = new URI(model.getSource());
            }
            catch (URISyntaxException uRISyntaxException) {
                arrayList.add(new SedMLError(0, "ErrMessageRoot[" + model.getSource() + "]", SedMLError.ERROR_SEVERITY.WARNING));
            }
        }
        return arrayList;
    }
}

