/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.contrib.input.LineNumberSAXBuilder;
import org.sedml.SEDMLDocument;
import org.sedml.SedML;
import org.sedml.SedMLError;
import org.sedml.XMLException;
import org.sedml.validation.AbstractDocumentValidator;
import org.sedml.validation.LineFinderUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchematronValidator
extends AbstractDocumentValidator {
    private static final String SVRL_NS_PREFIX = "svrl";
    private static final String SCHEMATRON_NS_URI = "http://purl.oclc.org/dsdl/svrl";
    private SedML sedml;
    XPathFactory xpf = XPathFactory.newInstance();

    SchematronValidator(Document document, SedML sedML) {
        super(document);
        this.sedml = sedML;
    }

    @Override
    public List<SedMLError> validate() throws XMLException {
        SEDMLDocument sEDMLDocument = new SEDMLDocument(this.sedml);
        ArrayList<SedMLError> arrayList = new ArrayList<SedMLError>();
        String string = sEDMLDocument.writeDocumentToString();
        InputStream inputStream = SchematronValidator.class.getClassLoader().getResourceAsStream("validator.xsl");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource streamSource = new StreamSource(inputStream);
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer(streamSource);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        try {
            transformer.transform(new StreamSource(new StringReader(string)), streamResult);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        String string2 = new String(byteArrayOutputStream.toByteArray());
        NodeList nodeList = this.getFailedAssertNodesFromReport(string2);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            String string3 = namedNodeMap.getNamedItem("location").getNodeValue();
            NodeList nodeList2 = this.getSedmlNodes(string3, string);
            if (nodeList2.getLength() <= 0) continue;
            Node node = nodeList2.item(0);
            String string4 = this.getMessageFromAssertFailedNode(nodeList, i);
            if (node.getAttributes().getNamedItem("id") != null) {
                int n = this.getLineNumber(node);
                arrayList.add(new SedMLError(n, string4, SedMLError.ERROR_SEVERITY.ERROR));
                continue;
            }
            if (!node.getLocalName().equals("ci") && !node.getLocalName().equals("cn")) continue;
            arrayList.add(new SedMLError(0, nodeList.item(i).getChildNodes().item(1).getTextContent(), SedMLError.ERROR_SEVERITY.ERROR));
        }
        return arrayList;
    }

    String getMessageFromAssertFailedNode(NodeList nodeList, int n) {
        NodeList nodeList2 = nodeList.item(n).getChildNodes();
        String string = "";
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            if (nodeList2.item(i).getNodeType() != 1) continue;
            string = nodeList2.item(i).getTextContent();
            break;
        }
        return string;
    }

    int getLineNumber(Node node) {
        LineFinderUtil lineFinderUtil = new LineFinderUtil();
        int n = lineFinderUtil.getLineForElement(node.getLocalName(), node.getAttributes().getNamedItem("id").getNodeValue(), this.getDoc());
        return n;
    }

    private NodeList getSedmlNodes(String string, String string2) {
        org.w3c.dom.Document document = SchematronValidator.getXMLDocumentFromModelString(string2);
        XPath xPath = this.xpf.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String string) {
                return Arrays.asList(SchematronValidator.SVRL_NS_PREFIX).iterator();
            }

            public String getPrefix(String string) {
                if (string.equals(SchematronValidator.SCHEMATRON_NS_URI)) {
                    return SchematronValidator.SVRL_NS_PREFIX;
                }
                return "";
            }

            public String getNamespaceURI(String string) {
                if (string.equals(SchematronValidator.SVRL_NS_PREFIX)) {
                    return SchematronValidator.SCHEMATRON_NS_URI;
                }
                return "";
            }
        });
        try {
            XPathExpression xPathExpression = xPath.compile(string);
            Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)object;
            return nodeList;
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
            return null;
        }
    }

    NodeList getFailedAssertNodesFromReport(String string) {
        org.w3c.dom.Document document = SchematronValidator.getXMLDocumentFromModelString(string);
        String string2 = "//svrl:failed-assert";
        XPath xPath = this.xpf.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String string) {
                return Arrays.asList(SchematronValidator.SVRL_NS_PREFIX).iterator();
            }

            public String getPrefix(String string) {
                if (string.equals(SchematronValidator.SCHEMATRON_NS_URI)) {
                    return SchematronValidator.SVRL_NS_PREFIX;
                }
                return "";
            }

            public String getNamespaceURI(String string) {
                if (string.equals(SchematronValidator.SVRL_NS_PREFIX)) {
                    return SchematronValidator.SCHEMATRON_NS_URI;
                }
                return "";
            }
        });
        try {
            XPathExpression xPathExpression = xPath.compile(string2);
            Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)object;
            return nodeList;
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
            return null;
        }
    }

    private Document createDocument(String string) throws XMLException {
        Document document;
        LineNumberSAXBuilder lineNumberSAXBuilder = new LineNumberSAXBuilder();
        try {
            document = lineNumberSAXBuilder.build((Reader)new StringReader(string));
        }
        catch (JDOMException jDOMException) {
            throw new XMLException("Error reading file", (Exception)((Object)jDOMException));
        }
        catch (IOException iOException) {
            throw new XMLException("Error reading file", iOException);
        }
        return document;
    }

    static org.w3c.dom.Document getXMLDocumentFromModelString(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
            byteArrayOutputStream.close();
            org.w3c.dom.Document document = documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

