/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.validation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.sedml.SedMLError;
import org.sedml.XMLException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SchemaValidatorImpl {
    static final String SEDML_SCHEMA = "schema.xsd";
    static final String SBML_MATHML_SCHEMA = "sedml-mathml.xsd";

    SchemaValidatorImpl() {
    }

    public void validateSedMLString(List<SedMLError> list, String string) throws XMLException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        File file = this.loadSchema(SBML_MATHML_SCHEMA);
        File file2 = this.loadSchema(SEDML_SCHEMA);
        StreamSource streamSource = new StreamSource(file);
        StreamSource streamSource2 = new StreamSource(file2);
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(new Source[]{streamSource, streamSource2});
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException.getMessage());
            throw new XMLException("Error parsing schema files", sAXException);
        }
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new DefaultXMLParsingErrorHandler(list));
        try {
            validator.validate(new StreamSource(new StringReader(string)));
        }
        catch (SAXException sAXException) {
            throw new XMLException("Error parsing XML", sAXException);
        }
        catch (IOException iOException) {
            throw new XMLException("Error parsing XML", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File loadSchema(String string) {
        InputStream inputStream = SchemaValidatorImpl.class.getClassLoader().getResourceAsStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileOutputStream fileOutputStream = null;
        File file = null;
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            file = File.createTempFile("xsd", "xsd");
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultXMLParsingErrorHandler
    implements ErrorHandler {
        private List<SedMLError> errors;

        public DefaultXMLParsingErrorHandler(List<SedMLError> list) {
            this.errors = list;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.errors.add(new SedMLError(sAXParseException.getLineNumber(), sAXParseException.getMessage(), SedMLError.ERROR_SEVERITY.WARNING));
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errors.add(new SedMLError(sAXParseException.getLineNumber(), sAXParseException.getMessage(), SedMLError.ERROR_SEVERITY.FATAL));
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.errors.add(new SedMLError(sAXParseException.getLineNumber(), sAXParseException.getMessage(), SedMLError.ERROR_SEVERITY.ERROR));
        }
    }
}

