/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdom.Document;
import org.sedml.Model;
import org.sedml.SedML;
import org.sedml.SedMLError;
import org.sedml.XMLException;
import org.sedml.validation.AbstractDocumentValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCyclesDetector
extends AbstractDocumentValidator {
    private SedML sedml;

    ModelCyclesDetector(SedML sedML, Document document) {
        super(document);
        this.sedml = sedML;
    }

    @Override
    public List<SedMLError> validate() throws XMLException {
        ArrayList<SedMLError> arrayList = new ArrayList<SedMLError>();
        List<Model> list = this.sedml.getModels();
        for (Model model : list) {
            String string = model.getSource();
            String string2 = model.getId();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string2);
            while (this.sedml.getModelWithId(string) != null) {
                String string3 = this.sedml.getModelWithId(string).getId();
                if (hashSet.contains(string3)) {
                    int n = this.getLineNumberOfError("model", model);
                    arrayList.add(new SedMLError(n, "Cycles detected in source references for model " + string3 + " and " + this.sedml.getModelWithId(string3).getSource(), SedMLError.ERROR_SEVERITY.ERROR));
                    return arrayList;
                }
                hashSet.add(string3);
                string = this.sedml.getModelWithId(string).getSource();
            }
        }
        return arrayList;
    }
}

