/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.validation;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.sedml.SedMLError;
import org.sedml.Simulation;
import org.sedml.modelsupport.KisaoOntology;
import org.sedml.validation.AbstractDocumentValidator;
import org.sedml.validation.ISedMLValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KisaoIDValidator
extends AbstractDocumentValidator
implements ISedMLValidator {
    private List<Simulation> sims;

    KisaoIDValidator(List<Simulation> list, Document document) {
        super(document);
        this.sims = list;
    }

    @Override
    public List<SedMLError> validate() {
        ArrayList<SedMLError> arrayList = new ArrayList<SedMLError>();
        for (Simulation simulation : this.sims) {
            String string = simulation.getAlgorithm().getKisaoID();
            if (KisaoOntology.getInstance().getTermById(string) != null) continue;
            int n = this.getLineNumberOfError("uniformTimeCourse", simulation);
            arrayList.add(new SedMLError(n, " The supplied KisaoID [" + string + "] for simulation [" + simulation.getId() + "]  is not a recognized KISAO identifier.\n" + " Identifiers should be the format 'KISAO:0000001' ", SedMLError.ERROR_SEVERITY.WARNING));
        }
        return arrayList;
    }
}

