/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.modelsupport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sedml.execution.IXPathToVariableIDResolver;
import org.sedml.modelsupport.SUPPORTED_LANGUAGE;

public class SBMLSupport
implements IXPathToVariableIDResolver {
    public static final Pattern XPATH_ID_RESOLVER = Pattern.compile("@\\S+='(\\S+)'");

    public SUPPORTED_LANGUAGE getLanguageFor(int n, int n2) {
        switch (n) {
            case 1: {
                switch (n2) {
                    case 1: {
                        return SUPPORTED_LANGUAGE.SBML_L1V1;
                    }
                    case 2: {
                        return SUPPORTED_LANGUAGE.SBML_L1V2;
                    }
                }
                return SUPPORTED_LANGUAGE.SBML_GENERIC;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        return SUPPORTED_LANGUAGE.SBML_L2V1;
                    }
                    case 2: {
                        return SUPPORTED_LANGUAGE.SBML_L2V2;
                    }
                    case 3: {
                        return SUPPORTED_LANGUAGE.SBML_L2V3Rel1;
                    }
                    case 4: {
                        return SUPPORTED_LANGUAGE.SBML_L2V4;
                    }
                }
                return SUPPORTED_LANGUAGE.SBML_GENERIC;
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        return SUPPORTED_LANGUAGE.SBML_L3V1;
                    }
                }
                return SUPPORTED_LANGUAGE.SBML_GENERIC;
            }
        }
        return SUPPORTED_LANGUAGE.SBML_GENERIC;
    }

    public String getIdFromXPathIdentifer(String string) {
        Matcher matcher = XPATH_ID_RESOLVER.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getXPathForGlobalParameter(String string) {
        return this.getXPathForListOfParameters() + "/sbml:parameter[@id='" + string + "']";
    }

    public String getXPathForGlobalParameter(String string, ParameterAttribute parameterAttribute) {
        return this.getXPathForListOfParameters() + "/sbml:parameter[@id='" + string + "']" + "/@" + (Object)((Object)parameterAttribute);
    }

    public String getXPathForSpecies(String string) {
        return this.getXPathForListOfSpecies() + "/sbml:species[@id='" + string + "']";
    }

    public String getXPathForSpecies(String string, SpeciesAttribute speciesAttribute) {
        return this.getXPathForListOfSpecies() + "/sbml:species[@id='" + string + "']" + "/@" + (Object)((Object)speciesAttribute);
    }

    public String getXPathForCompartment(String string) {
        return this.getXPathForListOfCompartments() + "/sbml:compartment[@id='" + string + "']";
    }

    public String getXPathForCompartment(String string, CompartmentAttribute compartmentAttribute) {
        return this.getXPathForListOfCompartments() + "/sbml:compartment[@id='" + string + "']" + "/@" + (Object)((Object)compartmentAttribute);
    }

    String getXPathForListOfCompartments() {
        return "/sbml:sbml/sbml:model/sbml:listOfCompartments";
    }

    String getXPathForListOfParameters() {
        return "/sbml:sbml/sbml:model/sbml:listOfParameters";
    }

    String getXPathForListOfSpecies() {
        return "/sbml:sbml/sbml:model/sbml:listOfSpecies";
    }

    String getXPathForListOfReactions() {
        return "/sbml:sbml/sbml:model/sbml:listOfReactions";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpeciesAttribute {
        initialAmount,
        initialConcentration,
        constant,
        substanceUnits,
        hasOnlySubstanceUnits;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParameterAttribute {
        value;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompartmentAttribute {
        size,
        spatialDimensions;

    }
}

