/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.modelsupport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sedml.modelsupport.KisaoOntology;
import org.sedml.modelsupport.KisaoTerm;

class KisaoTermParser {
    final String Kisao_OBO = "kisao_rev28_vSat_Jan_24_18-58-35_2009_UTC-2.obo";
    final String TERM_PATTERN = "\\[Term\\]";
    final Pattern ID_PATTERN = Pattern.compile("id:\\s*(.+)");
    final Pattern NAME_PATTERN = Pattern.compile("name:\\s*(.+)");
    final Pattern DEF_PATTERN = Pattern.compile("def:\\s*(.+)");
    final Pattern ISA_PATTERN = Pattern.compile("is_a:\\s*(\\S+)");
    final Pattern IS_OBSOLETE = Pattern.compile("is_obsolete:");
    final Pattern EXACT_SYN = Pattern.compile("exact_synonym:\\s\"(.+)\"");
    final Pattern NARROW_SYN = Pattern.compile("narrow_synonym:\\s\"(.+)\"");

    KisaoTermParser() {
    }

    KisaoOntology parse() {
        InputStream inputStream = KisaoTermParser.class.getClassLoader().getResourceAsStream("kisao_rev28_vSat_Jan_24_18-58-35_2009_UTC-2.obo");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        boolean bl = true;
        boolean bl2 = false;
        KisaoOntology kisaoOntology = new KisaoOntology();
        KisaoTerm kisaoTerm = null;
        new KisaoTerm();
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (string.matches("\\[Term\\]")) {
                    bl2 = true;
                    kisaoTerm = new KisaoTerm();
                }
                if (string.matches("^$") && kisaoTerm != null) {
                    bl2 = false;
                    bl = false;
                    kisaoOntology.add(kisaoTerm);
                    kisaoTerm = null;
                }
                if (!bl2) continue;
                Matcher matcher = this.ID_PATTERN.matcher(string);
                if (matcher.find()) {
                    kisaoTerm.setId(matcher.group(1));
                }
                if ((matcher = this.NAME_PATTERN.matcher(string)).find()) {
                    kisaoTerm.setName(matcher.group(1));
                }
                if ((matcher = this.DEF_PATTERN.matcher(string)).find()) {
                    kisaoTerm.setDef(matcher.group(1));
                }
                if ((matcher = this.EXACT_SYN.matcher(string)).find()) {
                    kisaoTerm.addExactSynonym(matcher.group(1));
                }
                if ((matcher = this.NARROW_SYN.matcher(string)).find()) {
                    kisaoTerm.addNarrowSynonym(matcher.group(1));
                }
                if ((matcher = this.ISA_PATTERN.matcher(string)).find()) {
                    kisaoTerm.addIsaRef(matcher.group(1));
                }
                if (!(matcher = this.IS_OBSOLETE.matcher(string)).find()) continue;
                kisaoTerm.setObsolete(true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        kisaoOntology.createRelations();
        return kisaoOntology;
    }
}

