/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.modelsupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sedml.modelsupport.KisaoTerm;
import org.sedml.modelsupport.KisaoTermParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KisaoOntology {
    public static KisaoTerm ALGORITHM_WITH_DETERMINISTIC_RULES = KisaoOntology.getInstance().getTermById("KISAO:0000035");
    private List<KisaoTerm> terms = new ArrayList<KisaoTerm>();
    private static KisaoOntology instance;

    public static KisaoOntology getInstance() {
        if (instance == null) {
            instance = new KisaoTermParser().parse();
        }
        return instance;
    }

    void add(KisaoTerm kisaoTerm) {
        this.terms.add(kisaoTerm);
    }

    public List<KisaoTerm> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    public KisaoTerm getTermById(String string) {
        for (KisaoTerm kisaoTerm : this.terms) {
            if (!kisaoTerm.getId().equalsIgnoreCase(string)) continue;
            return kisaoTerm;
        }
        return null;
    }

    void createRelations() {
        for (KisaoTerm kisaoTerm : this.terms) {
            List<String> list = kisaoTerm.getIsaRef();
            for (String string : list) {
                KisaoTerm kisaoTerm2 = this.getTermById(string);
                if (kisaoTerm2 == null) continue;
                kisaoTerm.addISA(kisaoTerm2);
            }
        }
    }
}

