/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jmathml.ASTCi;
import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.EvaluationContext;
import org.jmathml.IEvaluationContext;
import org.sedml.DataGenerator;
import org.sedml.Output;
import org.sedml.Parameter;
import org.sedml.SedML;
import org.sedml.Task;
import org.sedml.Variable;
import org.sedml.VariableSymbol;
import org.sedml.execution.ExecutionStatusElement;
import org.sedml.execution.IModel2DataMappings;
import org.sedml.execution.IProcessedSedMLSimulationResults;
import org.sedml.execution.IRawSedmlSimulationResults;
import org.sedml.execution.IXPathToVariableIDResolver;
import org.sedml.execution.SedmlData;
import org.sedml.modelsupport.SBMLSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedMLResultsProcesser2 {
    static final String MISSING_DG_MESSAGE = "Could not identify a data generator for dataset - missing out this data set: ";
    static final String NO_DATACOLuMN_FORID_MSG = "Could not identify a data column for variable ";
    static final String COULD_NOT_RESOLVE_MATHML_MSG = "Could not resolve the variables in the Mathml required for generating ";
    static final String NO_DG_INOUTPUT_MSG = "No data generators listed in output";
    static final String COULD_NOT_EXECUTE_MATHML_FOR = "Math could not be executed for data generator ";
    private SedML sedml;
    private Output output;
    private IProcessedSedMLSimulationResults toReturn;
    private ProcessReport report = new ProcessReport();
    private IXPathToVariableIDResolver variable2IDResolver = new SBMLSupport();

    public SedMLResultsProcesser2(SedML sedML, Output output) {
        if (sedML == null || output == null) {
            throw new IllegalArgumentException();
        }
        this.sedml = sedML;
        this.output = output;
        boolean bl = false;
        for (Output output2 : sedML.getOutputs()) {
            if (!output2.getId().equals(output.getId())) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("Output [" + output.getId() + "] does not belong the SED-ML object. ");
        }
    }

    public void process(Map<Task, IRawSedmlSimulationResults> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        HashMap<Task, double[][]> hashMap = new HashMap<Task, double[][]>();
        int n = 0;
        n = this.makeDefensiveCopyOfData(map, hashMap, n);
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        if (this.output.getAllDataGeneratorReferences().isEmpty()) {
            this.report.messages.add(new ExecutionStatusElement(null, NO_DG_INOUTPUT_MSG, ExecutionStatusElement.ExecutionStatusType.ERROR));
            return;
        }
        for (String string : this.output.getAllDataGeneratorReferences()) {
            Object object;
            int n2;
            Object object2;
            Task task2;
            double[] dArray = new double[n];
            arrayList.add(dArray);
            DataGenerator dataGenerator = this.sedml.getDataGeneratorWithId(string);
            if (dataGenerator == null) {
                this.report.messages.add(new ExecutionStatusElement(null, MISSING_DG_MESSAGE + string, ExecutionStatusElement.ExecutionStatusType.ERROR));
                return;
            }
            List<Variable> list = dataGenerator.getListOfVariables();
            List<Parameter> list2 = dataGenerator.getListOfParameters();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            HashMap<String, IRawSedmlSimulationResults> hashMap3 = new HashMap<String, IRawSedmlSimulationResults>();
            HashMap hashMap4 = new HashMap();
            String string2 = "";
            for (Variable variable : list) {
                if (variable.isVariable()) {
                    String string3 = this.variable2IDResolver.getIdFromXPathIdentifer(variable.getTarget());
                    String string4 = variable.getReference();
                    task2 = this.sedml.getTaskWithId(string4);
                    object2 = map.get(task2);
                    hashMap3.put(variable.getId(), (IRawSedmlSimulationResults)object2);
                    hashMap4.put(variable.getId(), hashMap.get(task2));
                    hashMap2.put(variable.getId(), string3);
                    continue;
                }
                if (!variable.isSymbol() || !variable.getSymbol().equals((Object)VariableSymbol.TIME)) continue;
                string2 = variable.getId();
                hashMap4.put(variable.getId(), hashMap.values().iterator().next());
                hashMap2.put(variable.getId(), variable.getId());
            }
            HashMap hashMap5 = new HashMap();
            for (Parameter parameter : list2) {
                hashMap5.put(parameter.getId(), parameter.getValue());
            }
            ASTNode object62 = dataGenerator.getMath();
            Set set = object62.getIdentifiers();
            for (Task task2 : set) {
                if (!task2.isVector()) continue;
                object2 = task2.getName();
                Object object3 = ((IRawSedmlSimulationResults)hashMap3.get(object2)).getMappings();
                n2 = object3.getColumnIndexFor((String)hashMap2.get(object2));
                if (n2 < 0 || n2 >= ((IRawSedmlSimulationResults)hashMap3.get(object2)).getNumColumns()) {
                    this.report.messages.add(new ExecutionStatusElement(null, NO_DATACOLuMN_FORID_MSG + task2, ExecutionStatusElement.ExecutionStatusType.ERROR));
                    return;
                }
                object = new EvaluationContext();
                Double[] doubleArray = ((IRawSedmlSimulationResults)hashMap3.get(object2)).getDataByColumnIndex(n2);
                object.setValueFor(object2, Arrays.asList(doubleArray));
                if (task2.getParentNode() == null || task2.getParentNode().getParentNode() == null) {
                    this.report.messages.add(new ExecutionStatusElement(null, "Could not evaluate [" + task2 + "] as symbol does not have parent element", ExecutionStatusElement.ExecutionStatusType.ERROR));
                    return;
                }
                if (!task2.getParentNode().canEvaluate((IEvaluationContext)object)) {
                    this.report.messages.add(new ExecutionStatusElement(null, "Could not evaluate [" + task2 + "] ", ExecutionStatusElement.ExecutionStatusType.ERROR));
                    return;
                }
                ASTNumber aSTNumber = task2.getParentNode().evaluate((IEvaluationContext)object);
                task2.getParentNode().getParentNode().replaceChild(task2.getParentNode(), (ASTNode)aSTNumber);
            }
            if (this.identifiersMapToData(set, hashMap2, hashMap5, hashMap3, string2)) {
                for (int i = 0; i < n; ++i) {
                    task2 = new EvaluationContext();
                    for (Object object3 : hashMap5.keySet()) {
                        task2.setValueFor((String)object3, (Double)hashMap5.get(object3));
                    }
                    for (Object object3 : set) {
                        if (hashMap5.get(object3.getName()) != null) continue;
                        n2 = 0;
                        if (!(object3.getName().equals(string2) || (n2 = (object = ((IRawSedmlSimulationResults)hashMap3.get(object3.getName())).getMappings()).getColumnIndexFor((String)hashMap2.get(object3.getName()))) >= 0 && n2 < ((IRawSedmlSimulationResults)hashMap3.get(object3.getName())).getNumColumns())) {
                            this.report.messages.add(new ExecutionStatusElement(null, NO_DATACOLuMN_FORID_MSG + object3, ExecutionStatusElement.ExecutionStatusType.ERROR));
                            return;
                        }
                        task2.setValueFor(object3.getName(), ((double[][])hashMap4.get(object3.getName()))[i][n2]);
                    }
                    if (object62.canEvaluate((IEvaluationContext)task2)) {
                        dArray[i] = object62.evaluate((IEvaluationContext)task2).getValue();
                        continue;
                    }
                    this.report.messages.add(new ExecutionStatusElement(null, COULD_NOT_EXECUTE_MATHML_FOR + string, ExecutionStatusElement.ExecutionStatusType.INFO));
                }
                continue;
            }
            this.report.messages.add(new ExecutionStatusElement(null, COULD_NOT_RESOLVE_MATHML_MSG + string, ExecutionStatusElement.ExecutionStatusType.ERROR));
            return;
        }
        this.toReturn = this.createData(arrayList, n);
    }

    public void setVariable2IDResolver(IXPathToVariableIDResolver iXPathToVariableIDResolver) {
        this.variable2IDResolver = iXPathToVariableIDResolver;
    }

    private int makeDefensiveCopyOfData(Map<Task, IRawSedmlSimulationResults> map, Map<Task, double[][]> map2, int n) {
        for (Task task : map.keySet()) {
            IRawSedmlSimulationResults iRawSedmlSimulationResults = map.get(task);
            n = iRawSedmlSimulationResults.getNumDataRows();
            double[][] dArray = iRawSedmlSimulationResults.getData();
            double[][] dArrayArray = new double[dArray.length][];
            int n2 = 0;
            for (double[] dArray2 : dArray) {
                double[] dArray3 = new double[dArray2.length];
                System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
                dArrayArray[n2++] = dArray3;
            }
            map2.put(task, dArrayArray);
        }
        return n;
    }

    private IProcessedSedMLSimulationResults createData(List<double[]> list, int n) {
        String[] stringArray = new String[list.size()];
        int n2 = 0;
        Object object = this.output.getAllDataGeneratorReferences().iterator();
        while (object.hasNext()) {
            stringArray[n2++] = object.next();
        }
        object = new double[n][stringArray.length];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                object[i][j] = list.get(j)[i];
            }
        }
        return new SedmlData((double[][])object, stringArray);
    }

    private boolean identifiersMapToData(Set<ASTCi> set, Map<String, String> map, Map<String, Double> map2, Map<String, IRawSedmlSimulationResults> map3, String string) {
        for (ASTCi aSTCi : set) {
            boolean bl = false;
            if (map2.get(aSTCi.getName()) != null) {
                bl = true;
            } else if (map.get(aSTCi.getName()) != null) {
                if (aSTCi.getName().equals(string)) {
                    bl = true;
                } else {
                    IModel2DataMappings iModel2DataMappings = map3.get(aSTCi.getName()).getMappings();
                    if (iModel2DataMappings.hasMappingFor(map.get(aSTCi.getName())) && iModel2DataMappings.getColumnTitleFor(map.get(aSTCi.getName())) != null || aSTCi.getName().equals(string)) {
                        bl = true;
                    }
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public IProcessedSedMLSimulationResults getProcessedResult() {
        return this.toReturn;
    }

    public ProcessReport getProcessingReport() {
        return this.report;
    }

    public boolean isProcessed() {
        return this.toReturn != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProcessReport {
        List<ExecutionStatusElement> messages = new ArrayList<ExecutionStatusElement>();

        public List<ExecutionStatusElement> getMessages() {
            return Collections.unmodifiableList(this.messages);
        }
    }
}

