/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.execution;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.sedml.Model;
import org.sedml.SEDMLDocument;
import org.sedml.SedML;
import org.sedml.execution.IModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelResolver {
    static final String MODEL_CANNOT_BE_RESOLVED_MSG = " The model could not be resolved from its source reference. ";
    static final String MODEL_SRC_NOT_VALID_URI = "The model 'source' attribute  is not a valid URI.";
    private SedML sedml;
    private String message = "";
    private List<IModelResolver> resolvers = new ArrayList<IModelResolver>();

    public ModelResolver(SedML sedML) {
        this.sedml = sedML;
    }

    public void add(IModelResolver iModelResolver) {
        this.resolvers.add(iModelResolver);
    }

    String getMessage() {
        return this.message;
    }

    public String getReferenceModelString(Model model) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getBaseModelRef(model, arrayList);
        if (string == null) {
            return null;
        }
        URI uRI = null;
        try {
            uRI = this.sedml.getModelWithId(string).getSourceURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.message = MODEL_SRC_NOT_VALID_URI;
            return null;
        }
        String string2 = this.getBaseModel(uRI);
        if (string2 == null) {
            this.message = " The model could not be resolved from its source reference. (Using uri: " + uRI + ")";
            return null;
        }
        return string2;
    }

    String getBaseModelRef(Model model, List<String> list) {
        this.getModelModificationTree(model, list);
        if (list.isEmpty()) {
            this.message = MODEL_CANNOT_BE_RESOLVED_MSG;
            return null;
        }
        String string = list.get(0);
        return string;
    }

    public String getModelString(Model model) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getBaseModelRef(model, arrayList);
        URI uRI = null;
        try {
            uRI = this.sedml.getModelWithId(string2).getSourceURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.message = MODEL_SRC_NOT_VALID_URI;
            return null;
        }
        if (!hashMap.containsKey(string2)) {
            string = this.getBaseModel(uRI);
            if (string == null) {
                this.message = " The model could not be resolved from its source reference. (Using uri: " + uRI + ")";
                return null;
            }
            hashMap.put(uRI.toString(), string);
        }
        string = this.applyModelChanges(arrayList, (String)hashMap.get(uRI.toString()));
        return string;
    }

    String applyModelChanges(List<String> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            try {
                string = new SEDMLDocument(this.sedml).getChangedModel(list.get(i), string);
                continue;
            }
            catch (Exception exception) {
                this.message = "Could not apply XPath changes for model id[" + list.get(i) + "]";
            }
        }
        return string;
    }

    final String getBaseModel(URI uRI) {
        for (IModelResolver iModelResolver : this.resolvers) {
            String string = iModelResolver.getModelXMLFor(uRI);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    void getModelModificationTree(Model model, List<String> list) {
        String string = model.getSource();
        list.add(model.getId());
        if (this.sedml.getModelWithId(string) != null) {
            this.getModelModificationTree(this.sedml.getModelWithId(string), list);
        } else {
            Collections.reverse(list);
        }
    }
}

