/*
 * Decompiled with CFR 0.152.
 */
package org.sedml.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sedml.DataGenerator;
import org.sedml.Model;
import org.sedml.Output;
import org.sedml.SedML;
import org.sedml.Simulation;
import org.sedml.Task;
import org.sedml.UniformTimeCourse;
import org.sedml.Variable;
import org.sedml.execution.ExecutionStatusElement;
import org.sedml.execution.FileModelResolver;
import org.sedml.execution.IModelResolver;
import org.sedml.execution.IRawSedmlSimulationResults;
import org.sedml.execution.ModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSedmlExecutor {
    protected final SedML sedml;
    private final Output output;
    private List<ExecutionStatusElement> failureMessages = new ArrayList<ExecutionStatusElement>();
    private ModelResolver modelResolver;
    private Task task = null;
    static final String NO_SIMULATABLE_TASK_ERROR1 = "Cannot simulate task [";
    static final String NO_SIMULATABLE_TASK_ERROR2 = "]. Either the simulation reference is corrupt or the simulation algorithm is not available.";
    static final String LANGUAGE_NOT_SUPPORTED_ERROR = "The modelling language is not supported: ";
    private static final String NO_TASKS_ERROR = "No Tasks could be resolved from the required output.";

    public AbstractSedmlExecutor(SedML sedML, Output output) {
        if (sedML == null || output == null) {
            throw new IllegalArgumentException();
        }
        this.sedml = sedML;
        this.output = output;
        this.modelResolver = new ModelResolver(this.sedml);
        this.modelResolver.add(new FileModelResolver());
    }

    public AbstractSedmlExecutor(SedML sedML, Task task) {
        if (sedML == null || task == null) {
            throw new IllegalArgumentException();
        }
        this.sedml = sedML;
        this.task = task;
        this.output = null;
        this.modelResolver = new ModelResolver(this.sedml);
        this.modelResolver.add(new FileModelResolver());
    }

    protected final void addModelResolver(IModelResolver iModelResolver) {
        this.modelResolver.add(iModelResolver);
    }

    protected final void addStatus(ExecutionStatusElement executionStatusElement) {
        this.failureMessages.add(executionStatusElement);
    }

    public final Map<Task, IRawSedmlSimulationResults> runSimulations() {
        this.failureMessages.clear();
        System.err.println("Running simulations");
        HashMap<Task, IRawSedmlSimulationResults> hashMap = new HashMap<Task, IRawSedmlSimulationResults>();
        Set<Object> set = new HashSet<Task>();
        if (this.task != null) {
            set.add(this.task);
        } else {
            set = this.findTasks(this.output);
        }
        if (set.isEmpty()) {
            this.addStatus(new ExecutionStatusElement(null, NO_TASKS_ERROR, ExecutionStatusElement.ExecutionStatusType.ERROR));
            return hashMap;
        }
        System.err.println("Got a task to execute");
        for (Task task : set) {
            if (this.getSimulatableTasks().contains(task)) continue;
            this.addStatus(new ExecutionStatusElement(null, NO_SIMULATABLE_TASK_ERROR1 + task.getId() + NO_SIMULATABLE_TASK_ERROR2, ExecutionStatusElement.ExecutionStatusType.ERROR));
            return hashMap;
        }
        for (Task task : set) {
            Model model = this.sedml.getModelWithId(task.getModelReference());
            if (!this.supportsLanguage(model.getLanguage())) {
                this.addStatus(new ExecutionStatusElement(null, LANGUAGE_NOT_SUPPORTED_ERROR + model.getLanguage(), ExecutionStatusElement.ExecutionStatusType.ERROR));
                return hashMap;
            }
            System.err.println("language is OK");
            String string = this.modelResolver.getModelString(model);
            if (string == null) {
                this.addStatus(new ExecutionStatusElement(null, this.modelResolver.getMessage(), ExecutionStatusElement.ExecutionStatusType.ERROR));
            }
            System.err.println("Ready to execute");
            IRawSedmlSimulationResults iRawSedmlSimulationResults = this.executeSimulation(string, (UniformTimeCourse)this.sedml.getSimulation(task.getSimulationReference()));
            if (iRawSedmlSimulationResults == null) {
                this.addStatus(new ExecutionStatusElement(null, "Simulation failed during execution: " + task.getSimulationReference() + " with model: " + task.getModelReference(), ExecutionStatusElement.ExecutionStatusType.ERROR));
                return hashMap;
            }
            System.err.println(iRawSedmlSimulationResults);
            hashMap.put(task, iRawSedmlSimulationResults);
        }
        return hashMap;
    }

    public final boolean isExecuted() {
        for (ExecutionStatusElement executionStatusElement : this.failureMessages) {
            if (!executionStatusElement.getType().equals((Object)ExecutionStatusElement.ExecutionStatusType.ERROR)) continue;
            return false;
        }
        return true;
    }

    public List<ExecutionStatusElement> getFailureMessages() {
        return Collections.unmodifiableList(this.failureMessages);
    }

    protected abstract boolean supportsLanguage(String var1);

    protected abstract boolean canExecuteSimulation(Simulation var1);

    protected abstract IRawSedmlSimulationResults executeSimulation(String var1, UniformTimeCourse var2);

    public List<Task> getSimulatableTasks() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        for (Task task : this.sedml.getTasks()) {
            Simulation simulation = this.sedml.getSimulation(task.getSimulationReference());
            if (simulation == null || !this.canExecuteSimulation(simulation)) continue;
            arrayList.add(task);
        }
        return arrayList;
    }

    private Set<Task> findTasks(Output output) {
        TreeSet<Task> treeSet = new TreeSet<Task>();
        TreeSet<DataGenerator> treeSet2 = new TreeSet<DataGenerator>();
        for (String object : output.getAllDataGeneratorReferences()) {
            treeSet2.add(this.sedml.getDataGeneratorWithId(object));
        }
        for (DataGenerator dataGenerator : treeSet2) {
            for (Variable variable : dataGenerator.getListOfVariables()) {
                treeSet.add(this.sedml.getTaskWithId(variable.getReference()));
            }
        }
        return treeSet;
    }
}

