/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sedml.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XPathTarget {
    public static final Pattern XPATH_PREFIX = Pattern.compile("(/|@)(\\w*):");
    private String xPathStr;

    public XPathTarget(String string) {
        Assert.checkNoNullArgs(string);
        Assert.stringsNotEmpty(string);
        this.xPathStr = string;
    }

    public final Set<String> getXPathPrefixes() {
        Matcher matcher = XPATH_PREFIX.matcher(this.xPathStr);
        HashSet<String> hashSet = new HashSet<String>();
        while (matcher.find()) {
            hashSet.add(matcher.group(2));
        }
        return hashSet;
    }

    public final String getTargetAsString() {
        return this.xPathStr;
    }

    public String toString() {
        return this.xPathStr;
    }
}

