/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import org.sedml.AbstractIdentifiableElement;
import org.sedml.Assert;
import org.sedml.SEDMLElementFactory;
import org.sedml.SEDMLVisitor;
import org.sedml.VariableSymbol;

public final class Variable
extends AbstractIdentifiableElement {
    private String targetXPathStr = null;
    private String reference = null;
    private VariableSymbol symbol;

    public Variable(String string, String string2, String string3, String string4) {
        super(string, string2);
        if (SEDMLElementFactory.getInstance().isStrictCreation()) {
            Assert.checkNoNullArgs(string3, string4);
        }
        this.targetXPathStr = string4;
        this.reference = string3;
    }

    public Variable(String string, String string2, String string3, VariableSymbol variableSymbol) {
        super(string, string2);
        Assert.checkNoNullArgs(new Object[]{string3, variableSymbol});
        this.symbol = variableSymbol;
        this.reference = string3;
    }

    public VariableSymbol getSymbol() {
        return this.symbol;
    }

    public boolean isSymbol() {
        return this.symbol != null;
    }

    public String toString() {
        return "Variable [name=" + this.getName() + ", reference=" + this.reference + ", symbol=" + (Object)((Object)this.symbol) + ", targetXPathStr=" + this.targetXPathStr + ", getId()=" + this.getId() + "]";
    }

    public boolean isVariable() {
        return this.targetXPathStr != null;
    }

    public boolean isTime() {
        return this.isSymbol() && this.symbol.equals((Object)VariableSymbol.TIME);
    }

    public final String getTarget() {
        return this.targetXPathStr;
    }

    public final String getReference() {
        return this.reference;
    }

    public String getElementName() {
        return "variable";
    }

    public boolean accept(SEDMLVisitor sEDMLVisitor) {
        return sEDMLVisitor.visit(this);
    }
}

