/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import org.sedml.AbstractIdentifiableElement;
import org.sedml.Algorithm;
import org.sedml.Assert;
import org.sedml.SEDMLElementFactory;
import org.sedml.SEDMLVisitor;

public abstract class Simulation
extends AbstractIdentifiableElement {
    private Algorithm algorithm;

    public String toString() {
        return "Simulation [algorithm=" + this.algorithm + ", name=" + this.getName() + ", getId()=" + this.getId() + "]";
    }

    public Simulation(String string, String string2, Algorithm algorithm) {
        super(string, string2);
        if (SEDMLElementFactory.getInstance().isStrictCreation()) {
            Assert.checkNoNullArgs(algorithm);
        }
        this.algorithm = algorithm;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        Assert.checkNoNullArgs(algorithm);
        this.algorithm = algorithm;
    }

    public abstract String getSimulationKind();

    public boolean accept(SEDMLVisitor sEDMLVisitor) {
        return sEDMLVisitor.visit(this);
    }
}

