/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Namespace;
import org.sedml.DataGenerator;
import org.sedml.Model;
import org.sedml.Output;
import org.sedml.SEDBase;
import org.sedml.SEDMLVisitor;
import org.sedml.Simulation;
import org.sedml.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SedML
extends SEDBase {
    private int level = 1;
    private int version = 1;
    private Namespace xmlns = null;
    private List additionalNamespaces = new ArrayList();
    private List<Model> models = new ArrayList<Model>();
    private List<Simulation> simulations = new ArrayList<Simulation>();
    private List<Task> tasks = new ArrayList<Task>();
    private List<DataGenerator> dataGenerators = new ArrayList<DataGenerator>();
    private List<Output> outputs = new ArrayList<Output>();

    public String toString() {
        return "SedML [level=" + this.level + "]";
    }

    SedML(int n, int n2, Namespace namespace) {
        this.level = n;
        this.version = n2;
        this.xmlns = namespace;
    }

    SedML(Namespace namespace) {
        this.xmlns = namespace;
        this.level = 1;
        this.version = 1;
    }

    public List<Model> getModels() {
        return Collections.unmodifiableList(this.models);
    }

    public List<Simulation> getSimulations() {
        return Collections.unmodifiableList(this.simulations);
    }

    public List<Task> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    @Override
    public String getElementName() {
        return "sedML";
    }

    public List<DataGenerator> getDataGenerators() {
        return Collections.unmodifiableList(this.dataGenerators);
    }

    public List<Output> getOutputs() {
        Collections.sort(this.outputs, new OutputComparator());
        return Collections.unmodifiableList(this.outputs);
    }

    public void setAdditionalNamespaces(List list) {
        this.additionalNamespaces = list;
    }

    public void setModels(List<Model> list) {
        this.models = list;
    }

    public boolean addModel(Model model) {
        if (!this.models.contains(model)) {
            return this.models.add(model);
        }
        return false;
    }

    public boolean removeModel(Model model) {
        return this.models.remove(model);
    }

    public void setSimulations(List<Simulation> list) {
        this.simulations = list;
    }

    public boolean addSimulation(Simulation simulation) {
        if (!this.simulations.contains(simulation)) {
            return this.simulations.add(simulation);
        }
        return false;
    }

    public boolean removeSimulation(Simulation simulation) {
        return this.simulations.remove(simulation);
    }

    public void setTasks(List<Task> list) {
        this.tasks = list;
    }

    public boolean addTask(Task task) {
        if (!this.tasks.contains(task)) {
            return this.tasks.add(task);
        }
        return false;
    }

    public boolean removeTask(Task task) {
        return this.tasks.remove(task);
    }

    public void setDataGenerators(List<DataGenerator> list) {
        this.dataGenerators = list;
    }

    public boolean addDataGenerator(DataGenerator dataGenerator) {
        if (!this.dataGenerators.contains(dataGenerator)) {
            return this.dataGenerators.add(dataGenerator);
        }
        return false;
    }

    public boolean removeDataGenerator(DataGenerator dataGenerator) {
        return this.dataGenerators.remove(dataGenerator);
    }

    public void setOutputs(List<Output> list) {
        this.outputs = list;
    }

    public boolean addOutput(Output output) {
        if (!this.outputs.contains(output)) {
            return this.outputs.add(output);
        }
        return false;
    }

    public boolean removeOutput(Output output) {
        return this.outputs.remove(output);
    }

    public Model getModelWithId(String string) {
        for (int i = 0; i < this.models.size(); ++i) {
            Model model = this.models.get(i);
            if (!model.getId().equals(string)) continue;
            return model;
        }
        return null;
    }

    public boolean isModel(String string) {
        for (int i = 0; i < this.models.size(); ++i) {
            Model model = this.models.get(i);
            if (!model.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Simulation getSimulation(String string) {
        for (int i = 0; i < this.simulations.size(); ++i) {
            Simulation simulation = this.simulations.get(i);
            if (!simulation.getId().equals(string)) continue;
            return simulation;
        }
        return null;
    }

    public Task getTaskWithId(String string) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            Task task = this.tasks.get(i);
            if (!task.getId().equals(string)) continue;
            return task;
        }
        return null;
    }

    public DataGenerator getDataGeneratorWithId(String string) {
        for (int i = 0; i < this.dataGenerators.size(); ++i) {
            DataGenerator dataGenerator = this.dataGenerators.get(i);
            if (!dataGenerator.getId().equals(string)) continue;
            return dataGenerator;
        }
        return null;
    }

    public Output getOutputWithId(String string) {
        for (int i = 0; i < this.outputs.size(); ++i) {
            Output output = this.outputs.get(i);
            if (!output.getId().equals(string)) continue;
            return output;
        }
        return null;
    }

    public List getAdditionalNamespaces() {
        return this.additionalNamespaces;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLevel() {
        return this.level;
    }

    public Namespace getNamespace() {
        return this.xmlns;
    }

    public List<Model> getBaseModels() {
        HashSet<Model> hashSet = new HashSet<Model>();
        for (Model object : this.getModels()) {
            if (this.getModelWithId(object.getSource()) != null) continue;
            hashSet.add(object);
        }
        ArrayList arrayList = new ArrayList();
        for (Model model : hashSet) {
            arrayList.add(model);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public boolean accept(SEDMLVisitor sEDMLVisitor) {
        if (!sEDMLVisitor.visit(this)) {
            return false;
        }
        for (Simulation abstractIdentifiableElement : this.getSimulations()) {
            if (abstractIdentifiableElement.accept(sEDMLVisitor)) continue;
            return false;
        }
        for (Task task : this.getTasks()) {
            if (task.accept(sEDMLVisitor)) continue;
            return false;
        }
        for (Model model : this.getModels()) {
            if (model.accept(sEDMLVisitor)) continue;
            return false;
        }
        for (DataGenerator dataGenerator : this.getDataGenerators()) {
            if (dataGenerator.accept(sEDMLVisitor)) continue;
            return false;
        }
        for (Output output : this.getOutputs()) {
            if (output.accept(sEDMLVisitor)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OutputComparator
    implements Comparator<Output> {
        static Map<String, Integer> changeKindOrder = new HashMap<String, Integer>();

        OutputComparator() {
        }

        @Override
        public int compare(Output output, Output output2) {
            return changeKindOrder.get(output.getKind()).compareTo(changeKindOrder.get(output2.getKind()));
        }

        static {
            changeKindOrder.put("Plot2D", 1);
            changeKindOrder.put("Plot3D", 2);
            changeKindOrder.put("Report", 3);
        }
    }
}

