/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jmathml.ASTToXMLElementVisitor;
import org.jmathml.ASTVisitor;
import org.sedml.AbstractIdentifiableElement;
import org.sedml.AddXML;
import org.sedml.Algorithm;
import org.sedml.Annotation;
import org.sedml.Change;
import org.sedml.ChangeAttribute;
import org.sedml.ChangeXML;
import org.sedml.ComputeChange;
import org.sedml.Curve;
import org.sedml.DataGenerator;
import org.sedml.DataSet;
import org.sedml.Model;
import org.sedml.Notes;
import org.sedml.Output;
import org.sedml.Parameter;
import org.sedml.Plot2D;
import org.sedml.Plot3D;
import org.sedml.Report;
import org.sedml.SEDBase;
import org.sedml.SedML;
import org.sedml.Simulation;
import org.sedml.Surface;
import org.sedml.Task;
import org.sedml.UniformTimeCourse;
import org.sedml.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SEDMLWriter {
    SEDMLWriter() {
    }

    Element getXML(SedML sedML) {
        Element element = new Element("sedML");
        element.setAttribute("version", "" + sedML.getVersion());
        element.setAttribute("level", "" + sedML.getLevel());
        List list = sedML.getAdditionalNamespaces();
        for (int i = 0; i < list.size(); ++i) {
            element.addNamespaceDeclaration((Namespace)list.get(i));
        }
        this.addNotesAndAnnotation(sedML, element);
        List<AbstractIdentifiableElement> list2 = sedML.getSimulations();
        Element element2 = new Element("listOfSimulations");
        for (int i = 0; i < list2.size(); ++i) {
            element2.addContent((Content)this.getXML(list2.get(i)));
        }
        element.addContent((Content)element2);
        list2 = sedML.getModels();
        Element element3 = new Element("listOfModels");
        for (int i = 0; i < list2.size(); ++i) {
            element3.addContent((Content)this.getXML((Model)list2.get(i)));
        }
        element.addContent((Content)element3);
        list2 = sedML.getTasks();
        Element element4 = new Element("listOfTasks");
        for (int i = 0; i < list2.size(); ++i) {
            element4.addContent((Content)this.getXML((Task)list2.get(i)));
        }
        element.addContent((Content)element4);
        list2 = sedML.getDataGenerators();
        Element element5 = new Element("listOfDataGenerators");
        for (int i = 0; i < list2.size(); ++i) {
            element5.addContent((Content)this.getXML((DataGenerator)list2.get(i)));
        }
        element.addContent((Content)element5);
        list2 = sedML.getOutputs();
        Element element6 = new Element("listOfOutputs");
        for (int i = 0; i < list2.size(); ++i) {
            element6.addContent((Content)this.getXML((Output)list2.get(i)));
        }
        element.addContent((Content)element6);
        element = this.setDefaultNamespace(element, Namespace.getNamespace((String)"http://sed-ml.org/"));
        return element;
    }

    Element getXML(Model model) {
        Element element = new Element("model");
        this.addNotesAndAnnotation(model, element);
        String string = null;
        string = model.getId();
        if (string != null) {
            element.setAttribute("id", model.getId());
        }
        if ((string = model.getName()) != null) {
            element.setAttribute("name", string);
        }
        if ((string = model.getLanguage()) != null) {
            element.setAttribute("language", string);
        }
        if ((string = model.getSource()) != null) {
            element.setAttribute("source", string);
        }
        if (model.getListOfChanges() != null && model.getListOfChanges().size() > 0) {
            element.addContent((Content)this.getXML(model.getListOfChanges()));
        }
        return element;
    }

    Element getXML(List<Change> list) {
        Element element = new Element("listOfChanges");
        for (int i = 0; i < list.size(); ++i) {
            element.addContent((Content)this.getXML(list.get(i)));
        }
        return element;
    }

    Element getXML(Change change) {
        Element element = null;
        String string = null;
        if (change.getChangeKind().equals("ChangeAttribute")) {
            element = new Element("changeAttribute");
            this.addNotesAndAnnotation(change, element);
            string = ((ChangeAttribute)change).getNewValue();
            if (string != null) {
                element.setAttribute("newValue", string);
            }
        } else if (change.getChangeKind().equals("ChangeXML")) {
            element = new Element("changeXML");
            this.addNotesAndAnnotation(change, element);
            Element element2 = new Element("newXML");
            element.addContent((Content)element2);
            for (Element element3 : ((ChangeXML)change).getNewXML().getXml()) {
                element2.addContent(element3.detach());
            }
        } else if (change.getChangeKind().equals("AddXML")) {
            element = new Element("addXML");
            this.addNotesAndAnnotation(change, element);
            Element element4 = new Element("newXML");
            element.addContent((Content)element4);
            for (Element element5 : ((AddXML)change).getNewXML().getXml()) {
                element4.addContent(element5.detach());
            }
        } else if (change.getChangeKind().equals("RemoveXML")) {
            element = new Element("removeXML");
            this.addNotesAndAnnotation(change, element);
        } else if (change.getChangeKind().equals("ComputeChange")) {
            element = new Element("computeChange");
            this.addNotesAndAnnotation(change, element);
            ComputeChange computeChange = (ComputeChange)change;
            Element element6 = new Element("listOfVariables");
            element.addContent((Content)element6);
            List<Variable> list = computeChange.getListOfVariables();
            for (Variable object2 : list) {
                element6.addContent((Content)this.getXML(object2, VariableType.COMPUTE_CHANGE));
            }
            Element element7 = new Element("listOfParameters");
            element.addContent((Content)element7);
            List<Parameter> list2 = computeChange.getListOfParameters();
            for (Parameter parameter : list2) {
                element7.addContent((Content)this.getXML(parameter));
            }
            ASTToXMLElementVisitor aSTToXMLElementVisitor = new ASTToXMLElementVisitor();
            computeChange.getMath().accept((ASTVisitor)aSTToXMLElementVisitor);
            element.addContent((Content)aSTToXMLElementVisitor.getElement());
        }
        element.setAttribute("target", change.getTargetXPath().getTargetAsString());
        return element;
    }

    Element getXML(Simulation simulation) {
        Element element = null;
        String string = null;
        if (simulation.getSimulationKind().equals("uniformTimeCourse")) {
            element = new Element("uniformTimeCourse");
            this.addNotesAndAnnotation(simulation, element);
            string = simulation.getId();
            if (string != null) {
                element.setAttribute("id", string);
            }
            if ((string = simulation.getName()) != null) {
                element.setAttribute("name", string);
            }
            element.setAttribute("initialTime", Double.toString(((UniformTimeCourse)simulation).getInitialTime()));
            element.setAttribute("outputStartTime", Double.toString(((UniformTimeCourse)simulation).getOutputStartTime()));
            element.setAttribute("outputEndTime", Double.toString(((UniformTimeCourse)simulation).getOutputEndTime()));
            element.setAttribute("numberOfPoints", Integer.toString(((UniformTimeCourse)simulation).getNumberOfPoints()));
        }
        if (simulation.getAlgorithm() != null) {
            element.addContent((Content)this.getXML(simulation.getAlgorithm()));
        }
        return element;
    }

    Element getXML(Algorithm algorithm) {
        String string = null;
        Element element = new Element("algorithm");
        this.addNotesAndAnnotation(algorithm, element);
        string = algorithm.getKisaoID();
        if (string != null) {
            element.setAttribute("kisaoID", string);
        }
        return element;
    }

    Element getXML(Task task) {
        Element element = new Element("task");
        this.addNotesAndAnnotation(task, element);
        String string = null;
        string = task.getId();
        if (string != null) {
            element.setAttribute("id", string);
        }
        if ((string = task.getName()) != null) {
            element.setAttribute("name", string);
        }
        if ((string = task.getModelReference()) != null) {
            element.setAttribute("modelReference", string);
        }
        if ((string = task.getSimulationReference()) != null) {
            element.setAttribute("simulationReference", string);
        }
        return element;
    }

    private void addNotesAndAnnotation(SEDBase sEDBase, Element element) {
        Element element2;
        for (Notes object : sEDBase.getNotes()) {
            element2 = new Element("notes");
            element2.addContent(object.getNotesElement().detach());
            element.addContent((Content)element2);
        }
        for (Annotation annotation : sEDBase.getAnnotation()) {
            element2 = new Element("annotation");
            element2.addContent(annotation.getAnnotationElement().detach());
            element.addContent((Content)element2);
        }
        if (sEDBase.getMetaId() != null) {
            element.setAttribute("metaid", sEDBase.getMetaId());
        }
    }

    Element getXML(DataGenerator dataGenerator) {
        Element element;
        List<Variable> list;
        Element element2 = new Element("dataGenerator");
        String string = null;
        this.addNotesAndAnnotation(dataGenerator, element2);
        string = dataGenerator.getId();
        if (string != null) {
            element2.setAttribute("id", dataGenerator.getId());
        }
        if ((string = dataGenerator.getName()) != null) {
            element2.setAttribute("name", string);
        }
        if ((list = dataGenerator.getListOfVariables()) != null && list.size() > 0) {
            element = new Element("listOfVariables");
            for (int i = 0; i < list.size(); ++i) {
                element.addContent((Content)this.getXML(list.get(i), VariableType.DATA_GENERATOR));
            }
            element2.addContent((Content)element);
        }
        if ((element = dataGenerator.getListOfParameters()) != null && element.size() > 0) {
            Element element3 = new Element("listOfParameters");
            for (int i = 0; i < element.size(); ++i) {
                element3.addContent((Content)this.getXML((Parameter)element.get(i)));
            }
            element2.addContent((Content)element3);
        }
        if (dataGenerator.getMath() != null) {
            try {
                ASTToXMLElementVisitor aSTToXMLElementVisitor = new ASTToXMLElementVisitor();
                dataGenerator.getMath().accept((ASTVisitor)aSTToXMLElementVisitor);
                element2.addContent((Content)aSTToXMLElementVisitor.getElement());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                throw new RuntimeException("Unable to process mathML for datagenerator '" + dataGenerator.getId() + "' : " + exception.getMessage());
            }
        }
        return element2;
    }

    Element getXML(Variable variable, VariableType variableType) {
        Element element = new Element("variable");
        this.addNotesAndAnnotation(variable, element);
        String string = null;
        string = variable.getId();
        if (string != null) {
            element.setAttribute("id", variable.getId());
        }
        if ((string = variable.getName()) != null) {
            element.setAttribute("name", string);
        }
        if ((string = variable.getReference()) != null && string.length() > 0 && variableType.equals((Object)VariableType.COMPUTE_CHANGE)) {
            element.setAttribute("modelReference", variable.getReference());
        } else if (string != null && string.length() > 0 && variableType.equals((Object)VariableType.DATA_GENERATOR)) {
            element.setAttribute("taskReference", variable.getReference());
        }
        if (variable.isVariable()) {
            string = variable.getTarget();
            if (string != null) {
                element.setAttribute("target", string);
            }
        } else if (variable.isSymbol() && (string = variable.getSymbol().getUrn()) != null) {
            element.setAttribute("symbol", string);
        }
        return element;
    }

    Element getXML(Parameter parameter) {
        Element element = new Element("parameter");
        String string = null;
        string = parameter.getId();
        if (string != null) {
            element.setAttribute("id", parameter.getId());
        }
        if ((string = parameter.getName()) != null) {
            element.setAttribute("name", string);
        }
        element.setAttribute("value", Double.toString(parameter.getValue()));
        this.addNotesAndAnnotation(parameter, element);
        return element;
    }

    Element getXML(Output output) {
        Element element = null;
        String string = null;
        if (output.getKind().equals("Plot2D")) {
            List<Curve> list;
            element = new Element("plot2D");
            this.addNotesAndAnnotation(output, element);
            string = output.getId();
            if (string != null) {
                element.setAttribute("id", output.getId());
            }
            if ((string = output.getName()) != null) {
                element.setAttribute("name", string);
            }
            if ((list = ((Plot2D)output).getListOfCurves()) != null && list.size() > 0) {
                Element element2 = new Element("listOfCurves");
                for (int i = 0; i < list.size(); ++i) {
                    element2.addContent((Content)this.getXML(list.get(i)));
                }
                element.addContent((Content)element2);
            }
        } else if (output.getKind().equals("Plot3D")) {
            List<Surface> list;
            element = new Element("plot3D");
            this.addNotesAndAnnotation(output, element);
            string = output.getId();
            if (string != null) {
                element.setAttribute("id", output.getId());
            }
            if ((string = output.getName()) != null) {
                element.setAttribute("name", string);
            }
            if ((list = ((Plot3D)output).getListOfSurfaces()) != null && list.size() > 0) {
                Element element3 = new Element("listOfSurfaces");
                for (int i = 0; i < list.size(); ++i) {
                    element3.addContent((Content)this.getXML(list.get(i)));
                }
                element.addContent((Content)element3);
            }
        } else if (output.getKind().equals("Report")) {
            List<DataSet> list;
            element = new Element("report");
            this.addNotesAndAnnotation(output, element);
            string = output.getId();
            if (string != null) {
                element.setAttribute("id", output.getId());
            }
            if ((string = output.getName()) != null) {
                element.setAttribute("name", string);
            }
            if ((list = ((Report)output).getListOfDataSets()) != null && list.size() > 0) {
                Element element4 = new Element("listOfDataSets");
                for (int i = 0; i < list.size(); ++i) {
                    element4.addContent((Content)this.getXML(list.get(i)));
                }
                element.addContent((Content)element4);
            }
        }
        return element;
    }

    Element getXML(Curve curve) {
        String string = null;
        Element element = new Element("curve");
        string = curve.getId();
        if (string != null) {
            element.setAttribute("id", string);
        }
        if ((string = curve.getName()) != null) {
            element.setAttribute("name", string);
        }
        element.setAttribute("logX", String.valueOf(curve.getLogX()));
        element.setAttribute("logY", String.valueOf(curve.getLogY()));
        string = curve.getXDataReference();
        if (string != null) {
            element.setAttribute("xDataReference", string);
        }
        if ((string = curve.getYDataReference()) != null) {
            element.setAttribute("yDataReference", string);
        }
        this.addNotesAndAnnotation(curve, element);
        return element;
    }

    Element getXML(Surface surface) {
        Element element = new Element("surface");
        String string = null;
        element.setAttribute("logZ", String.valueOf(surface.getLogZ()));
        string = surface.getId();
        if (string != null) {
            element.setAttribute("id", string);
        }
        if ((string = surface.getName()) != null) {
            element.setAttribute("name", string);
        }
        element.setAttribute("logX", String.valueOf(surface.getLogX()));
        element.setAttribute("logY", String.valueOf(surface.getLogY()));
        string = surface.getXDataReference();
        if (string != null) {
            element.setAttribute("xDataReference", string);
        }
        if ((string = surface.getYDataReference()) != null) {
            element.setAttribute("yDataReference", string);
        }
        if ((string = surface.getZDataReference()) != null) {
            element.setAttribute("zDataReference", string);
        }
        this.addNotesAndAnnotation(surface, element);
        return element;
    }

    Element getXML(DataSet dataSet) {
        String string = null;
        Element element = new Element("dataSet");
        string = dataSet.getDataReference();
        if (string != null) {
            element.setAttribute("dataReference", string);
        }
        if ((string = dataSet.getId()) != null) {
            element.setAttribute("id", string);
        }
        if ((string = dataSet.getName()) != null) {
            element.setAttribute("name", string);
        }
        if ((string = dataSet.getLabel()) != null) {
            element.setAttribute("label", string);
        }
        this.addNotesAndAnnotation(dataSet, element);
        return element;
    }

    private Element setDefaultNamespace(Element element, Namespace namespace) {
        if (element != null && element.getNamespaceURI().length() == 0) {
            element.setNamespace(namespace);
            for (Element element2 : element.getChildren()) {
                this.setDefaultNamespace(element2, namespace);
            }
        }
        return element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VariableType {
        COMPUTE_CHANGE,
        DATA_GENERATOR;

    }
}

