/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.io.File;
import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.xom.XOMXPath;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.sedml.Libsedml;
import org.sedml.SEDMLReader;
import org.sedml.SedML;
import org.sedml.modelsupport.ToolSupport;

public class SEDMLUtils {
    private static String parseXPath(String string, File file) {
        try {
            Builder builder = new Builder();
            Document document = builder.build(file);
            nu.xom.Element element = document.getRootElement();
            String string2 = element.getNamespaceURI();
            String string3 = element.getNamespacePrefix();
            if ("".equals(string3)) {
                ToolSupport.nameSpaces_PrefixesHashMap.put("sbml", string2);
            } else {
                ToolSupport.nameSpaces_PrefixesHashMap.put(string3, string2);
            }
            XOMXPath xOMXPath = new XOMXPath(string);
            xOMXPath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(ToolSupport.nameSpaces_PrefixesHashMap));
            Object object = xOMXPath.selectSingleNode((Object)document);
            String string4 = ((nu.xom.Element)object).getAttributeValue("id");
            System.out.println("Returned node id : " + string4);
            return string4;
        }
        catch (JaxenException jaxenException) {
            jaxenException.printStackTrace(System.out);
            throw new RuntimeException(jaxenException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
            throw new RuntimeException(iOException.getMessage());
        }
        catch (ParsingException parsingException) {
            parsingException.printStackTrace(System.out);
            throw new RuntimeException(parsingException.getMessage());
        }
    }

    static SedML readSedDocument(String string) {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            org.jdom.Document document = sAXBuilder.build(new File(string));
            Element element = document.getRootElement();
            SEDMLReader sEDMLReader = new SEDMLReader();
            SedML sedML = sEDMLReader.getSedDocument(element);
            return sedML;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new RuntimeException("Could not create SedMLDocument from file '" + string + "'");
        }
    }

    static String xmlToString(org.jdom.Document document, boolean bl) {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        return xMLOutputter.outputString(document);
    }

    public static String getVarFromXPathStr(String string, String string2) {
        if (string != null) {
            try {
                File file = File.createTempFile("tempxml", ".xml");
                File file2 = Libsedml.writeXMLStringToFile(string2, file.getAbsolutePath(), true);
                String string3 = SEDMLUtils.parseXPath(string, file2);
                return string3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Error parsing Xpath string : " + exception.getMessage());
            }
        }
        return null;
    }
}

