/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jmathml.ASTNode;
import org.jmathml.ASTRootNode;
import org.jmathml.ASTSymbolFactory;
import org.jmathml.MathMLReader;
import org.jmathml.SymbolRegistry;
import org.sedml.AddXML;
import org.sedml.Algorithm;
import org.sedml.Annotation;
import org.sedml.Change;
import org.sedml.ChangeAttribute;
import org.sedml.ChangeXML;
import org.sedml.ComputeChange;
import org.sedml.Curve;
import org.sedml.DataGenerator;
import org.sedml.DataSet;
import org.sedml.Model;
import org.sedml.NewXML;
import org.sedml.Notes;
import org.sedml.Output;
import org.sedml.Parameter;
import org.sedml.Plot2D;
import org.sedml.Plot3D;
import org.sedml.RemoveXML;
import org.sedml.Report;
import org.sedml.SEDBase;
import org.sedml.SedML;
import org.sedml.Simulation;
import org.sedml.Surface;
import org.sedml.Task;
import org.sedml.UniformTimeCourse;
import org.sedml.Variable;
import org.sedml.VariableSymbol;
import org.sedml.XMLException;
import org.sedml.XPathTarget;
import org.sedml.mathsymbols.SedMLSymbolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SEDMLReader {
    Namespace sedNS = null;

    SEDMLReader() {
    }

    Model getModel(Element element) throws DataConversionException {
        Model model = new Model(element.getAttributeValue("id"), element.getAttributeValue("name"), element.getAttributeValue("language"), element.getAttributeValue("source"));
        List list = element.getChildren();
        for (Element element2 : list) {
            if (!element2.getName().equals("listOfChanges")) continue;
            List list2 = element2.getChildren();
            for (Element element3 : list2) {
                Change change = this.getChange(element3);
                model.addChange(change);
            }
        }
        this.addNotesAndAnnotation(model, element);
        return model;
    }

    Change getChange(Element element) throws DataConversionException {
        Object object = null;
        if (element.getName().equals("changeAttribute")) {
            object = new ChangeAttribute(new XPathTarget(element.getAttributeValue("target")), element.getAttributeValue("newValue"));
        } else if (element.getName().equals("changeXML") || element.getName().equals("addXML")) {
            for (Element element2 : element.getChildren()) {
                if (!element2.getName().equals("newXML")) continue;
                List<Element> list = this.getNewXML(element2);
                NewXML newXML = new NewXML(list);
                if (element.getName().equals("changeXML")) {
                    object = new ChangeXML(new XPathTarget(element.getAttributeValue("target")), newXML);
                    continue;
                }
                object = new AddXML(new XPathTarget(element.getAttributeValue("target")), newXML);
            }
        } else if (element.getName().equals("removeXML")) {
            object = new RemoveXML(new XPathTarget(element.getAttributeValue("target")));
        } else if (element.getName().equals("computeChange")) {
            Object object22;
            ASTRootNode aSTRootNode = null;
            Object var4_6 = null;
            ArrayList<Variable> arrayList = new ArrayList<Variable>();
            ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
            for (Object object22 : element.getChildren()) {
                List list;
                if (object22.getName().equals("math")) {
                    aSTRootNode = (ASTRootNode)new MathMLReader().parseMathML((Element)object22);
                    continue;
                }
                if (object22.getName().equals("listOfVariables")) {
                    list = object22.getChildren();
                    for (Element element3 : list) {
                        if (!element3.getName().equals("variable")) continue;
                        arrayList.add(this.createVariable(element3, true));
                    }
                    continue;
                }
                if (!object22.getName().equals("listOfParameters")) continue;
                list = object22.getChildren();
                for (Element element3 : list) {
                    if (!element3.getName().equals("parameter")) continue;
                    arrayList2.add(this.createParameter(element3));
                }
            }
            object22 = new ComputeChange(new XPathTarget(element.getAttributeValue("target")), (ASTNode)aSTRootNode);
            ((ComputeChange)object22).setListOfParameters(arrayList2);
            ((ComputeChange)object22).setListOfVariables(arrayList);
            object = object22;
        }
        this.addNotesAndAnnotation((SEDBase)object, element);
        return object;
    }

    private void addNotesAndAnnotation(SEDBase sEDBase, Element element) {
        List list = element.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2.getName().equals("notes")) {
                Object object = this.getNotes(element2);
                if (object == null) continue;
                sEDBase.addNote((Notes)object);
                continue;
            }
            if (!element2.getName().equals("annotation")) continue;
            arrayList.add(element2);
        }
        for (Object object : arrayList) {
            sEDBase.addAnnotation(this.getAnnotation((Element)object));
        }
        sEDBase.setMetaId(element.getAttributeValue("metaid"));
    }

    Simulation getSimulation(Element element) {
        UniformTimeCourse uniformTimeCourse = null;
        List list = element.getChildren();
        Algorithm algorithm = null;
        for (Element element2 : list) {
            if (!element2.getName().equals("algorithm")) continue;
            algorithm = this.getAlgorithm(element2);
        }
        if (element.getName().equals("uniformTimeCourse")) {
            uniformTimeCourse = new UniformTimeCourse(element.getAttributeValue("id"), element.getAttributeValue("name"), Double.parseDouble(element.getAttributeValue("initialTime")), Double.parseDouble(element.getAttributeValue("outputStartTime")), Double.parseDouble(element.getAttributeValue("outputEndTime")), Integer.parseInt(element.getAttributeValue("numberOfPoints")), algorithm);
        }
        this.addNotesAndAnnotation(uniformTimeCourse, element);
        return uniformTimeCourse;
    }

    Algorithm getAlgorithm(Element element) {
        Algorithm algorithm = new Algorithm(element.getAttributeValue("kisaoID"));
        this.addNotesAndAnnotation(algorithm, element);
        return algorithm;
    }

    Task getTask(Element element) {
        Task task = null;
        task = new Task(element.getAttributeValue("id"), element.getAttributeValue("name"), element.getAttributeValue("modelReference"), element.getAttributeValue("simulationReference"));
        this.addNotesAndAnnotation(task, element);
        return task;
    }

    DataGenerator getDataGenerator(Element element) throws DataConversionException {
        DataGenerator dataGenerator = null;
        ASTRootNode aSTRootNode = null;
        dataGenerator = new DataGenerator(element.getAttributeValue("id"), element.getAttributeValue("name"));
        List list = element.getChildren();
        for (Element element2 : list) {
            List list2;
            if (element2.getName().equals("listOfVariables")) {
                list2 = element2.getChildren();
                for (Element element3 : list2) {
                    if (!element3.getName().equals("variable")) continue;
                    dataGenerator.addVariable(this.createVariable(element3, false));
                }
                continue;
            }
            if (element2.getName().equals("listOfParameters")) {
                list2 = element2.getChildren();
                for (Element element3 : list2) {
                    if (!element3.getName().equals("parameter")) continue;
                    dataGenerator.addParameter(this.createParameter(element3));
                }
                continue;
            }
            if (!element2.getName().equals("math")) continue;
            aSTRootNode = (ASTRootNode)new MathMLReader().parseMathML(element2);
        }
        dataGenerator.setMathML((ASTNode)aSTRootNode);
        this.addNotesAndAnnotation(dataGenerator, element);
        return dataGenerator;
    }

    Parameter createParameter(Element element) throws DataConversionException {
        Parameter parameter = new Parameter(element.getAttributeValue("id"), element.getAttributeValue("name"), element.getAttribute("value").getDoubleValue());
        this.addNotesAndAnnotation(parameter, element);
        return parameter;
    }

    Variable createVariable(Element element, boolean bl) {
        if (element.getAttribute("symbol") == null) {
            Variable variable = new Variable(element.getAttributeValue("id"), element.getAttributeValue("name"), bl ? element.getAttributeValue("modelReference") : element.getAttributeValue("taskReference"), element.getAttributeValue("target"));
            this.addNotesAndAnnotation(variable, element);
            return variable;
        }
        Variable variable = new Variable(element.getAttributeValue("id"), element.getAttributeValue("name"), bl ? element.getAttributeValue("modelReference") : element.getAttributeValue("taskReference"), VariableSymbol.getVariableSymbolFor(element.getAttributeValue("symbol")));
        this.addNotesAndAnnotation(variable, element);
        return variable;
    }

    Output getOutput(Element element) {
        if (element.getName().equals("plot2D")) {
            Plot2D plot2D = new Plot2D(element.getAttributeValue("id"), element.getAttributeValue("name"));
            List list = element.getChildren();
            for (Element element2 : list) {
                if (!element2.getName().equals("listOfCurves")) continue;
                List list2 = element2.getChildren();
                for (Element element3 : list2) {
                    if (!element3.getName().equals("curve")) continue;
                    Curve curve = this.getCurve(element3);
                    plot2D.addCurve(curve);
                }
            }
            this.addNotesAndAnnotation(plot2D, element);
            return plot2D;
        }
        if (element.getName().equals("plot3D")) {
            Plot3D plot3D = new Plot3D(element.getAttributeValue("id"), element.getAttributeValue("name"));
            List list = element.getChildren();
            for (Element element4 : list) {
                if (!element4.getName().equals("listOfSurfaces")) continue;
                List list3 = element4.getChildren();
                for (Element element5 : list3) {
                    if (!element5.getName().equals("surface")) continue;
                    Surface surface = this.getSurface(element5);
                    plot3D.addSurface(surface);
                }
            }
            this.addNotesAndAnnotation(plot3D, element);
            return plot3D;
        }
        if (element.getName().equals("report")) {
            Report report = new Report(element.getAttributeValue("id"), element.getAttributeValue("name"));
            List list = element.getChildren();
            for (Element element6 : list) {
                if (!element6.getName().equals("listOfDataSets")) continue;
                List list4 = element6.getChildren();
                for (Element element7 : list4) {
                    if (!element7.getName().equals("dataSet")) continue;
                    DataSet dataSet = this.getDataset(element7);
                    report.addDataSet(dataSet);
                }
            }
            this.addNotesAndAnnotation(report, element);
            return report;
        }
        return null;
    }

    DataSet getDataset(Element element) {
        DataSet dataSet = new DataSet(element.getAttributeValue("id"), element.getAttributeValue("name"), element.getAttributeValue("label"), element.getAttributeValue("dataReference"));
        this.addNotesAndAnnotation(dataSet, element);
        return dataSet;
    }

    Surface getSurface(Element element) {
        Surface surface = new Surface(element.getAttributeValue("id"), element.getAttributeValue("name"), Boolean.parseBoolean(element.getAttributeValue("logX")), Boolean.parseBoolean(element.getAttributeValue("logY")), Boolean.parseBoolean(element.getAttributeValue("logZ")), element.getAttributeValue("xDataReference"), element.getAttributeValue("yDataReference"), element.getAttributeValue("zDataReference"));
        this.addNotesAndAnnotation(surface, element);
        return surface;
    }

    Curve getCurve(Element element) {
        Curve curve = new Curve(element.getAttributeValue("id"), element.getAttributeValue("name"), Boolean.parseBoolean(element.getAttributeValue("logX")), Boolean.parseBoolean(element.getAttributeValue("logY")), element.getAttributeValue("xDataReference"), element.getAttributeValue("yDataReference"));
        this.addNotesAndAnnotation(curve, element);
        return curve;
    }

    List<Element> getNewXML(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = element.getChildren().size();
        for (int i = 0; i < n; ++i) {
            arrayList.add((Element)((Element)element.getChildren().get(0)).detach());
        }
        return arrayList;
    }

    Annotation getAnnotation(Element element) {
        return new Annotation((Element)((Element)element.getChildren().get(0)).detach());
    }

    Notes getNotes(Element element) {
        if (element.getChildren().size() > 0) {
            return new Notes((Element)((Element)element.getChildren().get(0)).detach());
        }
        return null;
    }

    SedML getSedDocument(Element element) throws XMLException {
        SedML sedML = null;
        SymbolRegistry.getInstance().addSymbolFactory((ASTSymbolFactory)new SedMLSymbolFactory());
        try {
            List list;
            Namespace namespace = element.getNamespace();
            String string = element.getAttributeValue("version");
            String string2 = element.getAttributeValue("level");
            if (string != null && string2 != null) {
                int n = Integer.parseInt(string);
                int n2 = Integer.parseInt(string2);
                sedML = new SedML(n2, n, namespace);
            } else {
                sedML = new SedML(namespace);
            }
            List list2 = element.getAdditionalNamespaces();
            sedML.setAdditionalNamespaces(list2);
            this.addNotesAndAnnotation(sedML, element);
            Iterator iterator = null;
            Element element2 = element.getChild("listOfModels", namespace);
            if (element2 != null) {
                list = element2.getChildren();
                for (Element element3 : list) {
                    if (!element3.getName().equals("model")) continue;
                    sedML.addModel(this.getModel(element3));
                }
            }
            if ((element2 = element.getChild("listOfSimulations", namespace)) != null) {
                list = element2.getChildren();
                for (Element element3 : list) {
                    if (!element3.getName().equals("uniformTimeCourse") && !element3.getName().equals("anySimulation")) continue;
                    sedML.addSimulation(this.getSimulation(element3));
                }
            }
            if ((element2 = element.getChild("listOfTasks", namespace)) != null) {
                list = element2.getChildren();
                for (Element element3 : list) {
                    if (!element3.getName().equals("task")) continue;
                    sedML.addTask(this.getTask(element3));
                }
            }
            if ((element2 = element.getChild("listOfDataGenerators", namespace)) != null) {
                list = element2.getChildren();
                for (Element element3 : list) {
                    if (!element3.getName().equals("dataGenerator")) continue;
                    sedML.addDataGenerator(this.getDataGenerator(element3));
                }
            }
            if ((element2 = element.getChild("listOfOutputs", namespace)) != null) {
                list = element2.getChildren();
                for (Element element3 : list) {
                    if (!element3.getName().equals("plot2D") && !element3.getName().equals("plot3D") && !element3.getName().equals("report")) continue;
                    sedML.addOutput(this.getOutput(element3));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new XMLException("Error loading sed-ml document : " + exception.getMessage());
        }
        return sedML;
    }
}

