/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.contrib.input.LineNumberSAXBuilder;
import org.jdom.output.XMLOutputter;
import org.sedml.AddXML;
import org.sedml.Assert;
import org.sedml.Change;
import org.sedml.ChangeXML;
import org.sedml.Libsedml;
import org.sedml.Model;
import org.sedml.ModelTransformationUtils;
import org.sedml.NamespaceContextHelper;
import org.sedml.SEDMLUtils;
import org.sedml.SEDMLWriter;
import org.sedml.SedML;
import org.sedml.SedMLError;
import org.sedml.SedMLValidationReport;
import org.sedml.Version;
import org.sedml.XMLException;
import org.sedml.XPathTarget;
import org.sedml.validation.ValidatorController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEDMLDocument {
    private List<SedMLError> errors = new ArrayList<SedMLError>();
    private SedML sedml;
    private boolean isValidationPerformed;

    public SEDMLDocument(SedML sedML, List<SedMLError> list) {
        Assert.checkNoNullArgs(sedML, list);
        this.sedml = sedML;
        this.errors = list;
    }

    public SEDMLDocument(SedML sedML) {
        this(sedML, new ArrayList<SedMLError>());
    }

    public SEDMLDocument() {
        this.sedml = new SedML(1, 1, Namespace.getNamespace((String)"http://sed-ml.org/"));
        this.sedml.setAdditionalNamespaces(Arrays.asList(Namespace.getNamespace((String)"math", (String)"http://www.w3.org/1998/Math/MathML")));
    }

    public List<SedMLError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public SedMLValidationReport getValidationReport() {
        if (!this.isValidationPerformed) {
            return null;
        }
        return new SedMLValidationReport(this.errors, SEDMLDocument.getSedMLDocumentAsString(this.sedml));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public SedML getSedMLModel() {
        return this.sedml;
    }

    public List<SedMLError> validate() throws XMLException {
        Document document = this.createDocument(this.writeDocumentToString());
        List<SedMLError> list = new ValidatorController().validate(this.sedml, document);
        list.addAll(this.errors);
        this.errors = list;
        this.isValidationPerformed = true;
        return this.getErrors();
    }

    public String toString() {
        return "SEDML Document for " + this.sedml.getNotes();
    }

    public void writeDocument(File file) {
        Assert.checkNoNullArgs(file);
        String string = SEDMLDocument.getSedMLDocumentAsString(this.sedml);
        try {
            Libsedml.writeXMLStringToFile(string, file.getAbsolutePath(), true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
            throw new RuntimeException("Unable to write SEDML to file : " + iOException.getMessage());
        }
    }

    static String getSedMLDocumentAsString(SedML sedML) {
        SEDMLWriter sEDMLWriter = new SEDMLWriter();
        Element element = sEDMLWriter.getXML(sedML);
        Document document = new Document();
        document.setRootElement(element);
        String string = SEDMLUtils.xmlToString(document, true);
        return string;
    }

    public String writeDocumentToString() {
        return SEDMLDocument.getSedMLDocumentAsString(this.sedml);
    }

    public Version getVersion() {
        return new Version(this.sedml.getLevel(), this.sedml.getVersion());
    }

    public String getChangedModel(String string, String string2) throws XPathExpressionException, XMLException {
        String string3 = "";
        Model model = this.sedml.getModelWithId(string);
        if (model == null || !model.hasChanges()) {
            return string2;
        }
        List<Change> list = model.getListOfChanges();
        try {
            org.w3c.dom.Document document = ModelTransformationUtils.getXMLDocumentFromModelString(string2);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            for (Change change : list) {
                Change change2;
                Document document2 = this.createDocument(string2);
                NamespaceContextHelper namespaceContextHelper = new NamespaceContextHelper(document2, change.getTargetXPath());
                xPath.setNamespaceContext(namespaceContextHelper);
                if (change.getChangeKind().equals("ChangeAttribute")) {
                    ModelTransformationUtils.applyAttributeChange(document, xPath, change);
                    continue;
                }
                if (change.getChangeKind().equals("RemoveXML")) {
                    ModelTransformationUtils.deleteXMLElement(document, change.getTargetXPath().getTargetAsString(), xPath);
                    continue;
                }
                if (change.getChangeKind().equals("AddXML")) {
                    change2 = (AddXML)change;
                    for (Element element : ((AddXML)change2).getNewXML().getXml()) {
                        element.setNamespace(Namespace.NO_NAMESPACE);
                        String string4 = new XMLOutputter().outputString(element);
                        System.err.println(string4);
                        ModelTransformationUtils.addXMLelement(document, string4, change2.getTargetXPath().getTargetAsString(), xPath);
                    }
                    continue;
                }
                if (!change.getChangeKind().equals("ChangeXML")) continue;
                change2 = (ChangeXML)change;
                ModelTransformationUtils.changeXMLElement(document, ((ChangeXML)change2).getNewXML(), change2.getTargetXPath().getTargetAsString(), xPath);
            }
            string3 = ModelTransformationUtils.exportChangedXMLAsString(document);
        }
        catch (Exception exception) {
            throw new XMLException("Error generating new model" + exception.getMessage(), exception);
        }
        return string3;
    }

    private Document createDocument(String string) throws XMLException {
        Document document;
        LineNumberSAXBuilder lineNumberSAXBuilder = new LineNumberSAXBuilder();
        try {
            document = lineNumberSAXBuilder.build((Reader)new StringReader(string));
        }
        catch (JDOMException jDOMException) {
            throw new XMLException("Error reading file", (Exception)((Object)jDOMException));
        }
        catch (IOException iOException) {
            throw new XMLException("Error reading file", iOException);
        }
        return document;
    }

    public boolean canResolveXPathExpressions(String string, String string2) throws XMLException {
        Document document = this.createDocument(string2);
        Model model = this.sedml.getModelWithId(string);
        List<Change> list = model.getListOfChanges();
        for (Change change : list) {
            XPathTarget xPathTarget = change.getTargetXPath();
            NamespaceContextHelper namespaceContextHelper = new NamespaceContextHelper(document, xPathTarget);
            if (namespaceContextHelper.isAllXPathPrefixesMapped(xPathTarget)) continue;
            return false;
        }
        return true;
    }
}

