/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.sedml.Curve;
import org.sedml.DataGenerator;
import org.sedml.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plot2D
extends Output {
    private ArrayList<Curve> listOfCurves = new ArrayList();

    public String toString() {
        return "Plot2D [listOfCurves=" + this.listOfCurves + ", name=" + this.getName() + "]";
    }

    public Plot2D(String string, String string2) {
        super(string, string2);
    }

    public List<Curve> getListOfCurves() {
        return Collections.unmodifiableList(this.listOfCurves);
    }

    @Override
    public String getKind() {
        return "Plot2D";
    }

    public boolean addCurve(Curve curve) {
        if (!this.listOfCurves.contains(curve)) {
            return this.listOfCurves.add(curve);
        }
        return false;
    }

    public boolean removeCurve(Curve curve) {
        return this.listOfCurves.remove(curve);
    }

    public List<Curve> getCurvesUsingDataGeneratorAsXAxis(DataGenerator dataGenerator) {
        ArrayList<Curve> arrayList = new ArrayList<Curve>();
        for (Curve curve : this.listOfCurves) {
            if (!curve.getXDataReference().equals(dataGenerator.getId())) continue;
            arrayList.add(curve);
        }
        return arrayList;
    }

    public List<Curve> getCurvesUsingDataGeneratorAsYAxis(DataGenerator dataGenerator) {
        ArrayList<Curve> arrayList = new ArrayList<Curve>();
        for (Curve curve : this.listOfCurves) {
            if (!curve.getYDataReference().equals(dataGenerator.getId())) continue;
            arrayList.add(curve);
        }
        return arrayList;
    }

    @Override
    public List<String> getAllDataGeneratorReferences() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Curve object : this.listOfCurves) {
            treeSet.add(object.getXDataReference());
            treeSet.add(object.getYDataReference());
        }
        ArrayList arrayList = new ArrayList();
        for (String string : treeSet) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public List<String> getAllIndependentDataGeneratorReferences() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Curve object : this.listOfCurves) {
            treeSet.add(object.getXDataReference());
        }
        ArrayList arrayList = new ArrayList();
        for (String string : treeSet) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public String getElementName() {
        return "plot2D";
    }
}

