/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.List;
import org.sedml.AbstractIdentifiableElement;
import org.sedml.Curve;
import org.sedml.DataSet;
import org.sedml.Plot2D;
import org.sedml.Plot3D;
import org.sedml.Report;
import org.sedml.SEDMLVisitor;
import org.sedml.Surface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Output
extends AbstractIdentifiableElement {
    @Override
    public boolean accept(SEDMLVisitor sEDMLVisitor) {
        if (sEDMLVisitor.visit(this)) {
            if (this.isPlot2d()) {
                for (Curve curve : ((Plot2D)this).getListOfCurves()) {
                    if (curve.accept(sEDMLVisitor)) continue;
                    return false;
                }
                return true;
            }
            if (this.isPlot3d()) {
                for (Surface surface : ((Plot3D)this).getListOfSurfaces()) {
                    if (surface.accept(sEDMLVisitor)) continue;
                    return false;
                }
                return true;
            }
            if (this.isReport()) {
                for (DataSet dataSet : ((Report)this).getListOfDataSets()) {
                    if (dataSet.accept(sEDMLVisitor)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Output(String string, String string2) {
        super(string, string2);
    }

    public abstract String getKind();

    public boolean isPlot2d() {
        return this.getKind().equals("Plot2D");
    }

    public boolean isPlot3d() {
        return this.getKind().equals("Plot3D");
    }

    public boolean isReport() {
        return this.getKind().equals("Report");
    }

    public abstract List<String> getAllDataGeneratorReferences();

    public abstract List<String> getAllIndependentDataGeneratorReferences();
}

