/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.sedml.XPathTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamespaceContextHelper
implements NamespaceContext {
    private Map<String, String> ns = new HashMap<String, String>();

    public NamespaceContextHelper() {
    }

    public NamespaceContextHelper(Map<String, String> map) {
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            this.add(string, string2);
        }
    }

    public NamespaceContextHelper(String string, String string2) {
        this.add(string, string2);
    }

    public void add(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("Null prefix or uri passed to NamespaceContextHelper");
        }
        if (this.ns.containsKey(string)) {
            String string3 = this.ns.get(string);
            if (string2.equals(string3)) {
                return;
            }
            throw new IllegalArgumentException("Attempt to change binding in NamespaceContextHelper");
        }
        if ("xml".equals(string) && !"http://www.w3.org/XML/1998/namespace".equals(string2)) {
            throw new IllegalArgumentException("The prefix 'xml' can only be bound to 'http://www.w3.org/XML/1998/namespace' in NamespaceContextHelper");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string2) && !"xml".equals(string)) {
            throw new IllegalArgumentException("The namespace 'http://www.w3.org/XML/1998/namespace' can only have the prefix 'xml' in NamespaceContextHelper");
        }
        if ("xmlns".equals(string) || "http://www.w3.org/2000/xmlns".equals(string2)) {
            throw new IllegalArgumentException("Neither the prefix 'xmlns' nor the URI 'http://www.w3.org/2000/xmlns' can be bound in NamespaceContextHelper");
        }
        if ("".equals(string)) {
            this.ns.put(string, string2);
        } else if (string.matches("\\w+")) {
            this.ns.put(string, string2);
        } else {
            throw new IllegalArgumentException("Prefix is not a valid NCName in NamespaceContextHelper");
        }
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.ns.get(string);
    }

    NamespaceContextHelper(Document document, XPathTarget xPathTarget) {
        Object object32;
        Object object2;
        Iterator iterator = document.getDescendants((Filter)new ElementFilter());
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            object2 = (Element)iterator.next();
            object32 = object2.getNamespace();
            if (object32 == null || hashSet.contains(object32)) continue;
            hashSet.add(object32);
        }
        for (Object object32 : hashSet) {
            System.out.println(object32.getURI());
        }
        object2 = xPathTarget.getXPathPrefixes();
        object32 = object2.iterator();
        while (object32.hasNext()) {
            String string = (String)object32.next();
            for (Namespace namespace : hashSet) {
                if (!namespace.getPrefix().toLowerCase().equals(string.toLowerCase()) && (!"".equals(namespace.getPrefix()) || !namespace.getURI().toLowerCase().contains(string.toLowerCase())) || this.getNamespaceURI(string) != null) continue;
                this.add(string, namespace.getURI());
            }
        }
    }

    boolean isAllXPathPrefixesMapped(XPathTarget xPathTarget) {
        Set<String> set = xPathTarget.getXPathPrefixes();
        for (String string : set) {
            if (this.ns.get(string) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getPrefix(String string) {
        if (this.ns.containsValue(string)) {
            for (String string2 : this.ns.keySet()) {
                String string3 = this.ns.get(string2);
                if (!string.equals(string3)) continue;
                return string2;
            }
        }
        return null;
    }

    public Iterator getPrefixes() {
        return this.getPrefixes(null);
    }

    public Iterator getPrefixes(String string) {
        return new NSIterator(this.ns, string);
    }

    public Iterator getNamespaceURIs() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.ns.keySet()) {
            String string2 = this.ns.get(string);
            if (hashMap.containsKey(string2)) continue;
            hashMap.put(string2, string);
        }
        return new NSIterator(hashMap, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NSIterator
    implements Iterator {
        private Iterator<String> keys;

        public NSIterator(Map<String, String> map, String string) {
            this.keys = map.keySet().iterator();
            if (string != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (this.keys.hasNext()) {
                    String string2 = this.keys.next();
                    String string3 = map.get(string2);
                    if (!string3.equals(string)) continue;
                    hashMap.put(string2, string3);
                }
                this.keys = hashMap.keySet().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public String next() {
            return this.keys.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove prefix in NamespaceContextHelper");
        }
    }
}

