/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;
import org.sedml.Change;
import org.sedml.ChangeAttribute;
import org.sedml.NewXML;
import org.sedml.XMLException;
import org.sedml.XPathEvaluationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ModelTransformationUtils {
    ModelTransformationUtils() {
    }

    static void deleteXMLElement(Document document, String string, XPath xPath) throws XMLException, XPathEvaluationException {
        Object object = ModelTransformationUtils.applyXpath(string, xPath, document);
        NodeList nodeList = (NodeList)object;
        ModelTransformationUtils.removeChild(nodeList);
    }

    private static void removeChild(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodeList.item(i).getParentNode().removeChild(nodeList.item(i));
        }
    }

    static void changeXMLElement(Document document, NewXML newXML, String string, XPath xPath) throws XMLException, XPathEvaluationException {
        Object object = ModelTransformationUtils.applyXpath(string, xPath, document);
        NodeList nodeList = (NodeList)object;
        try {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i).getParentNode();
                ModelTransformationUtils.removeChild(nodeList);
                for (Element element : newXML.getXml()) {
                    element.setNamespace(Namespace.NO_NAMESPACE);
                    String string2 = new XMLOutputter().outputString(element);
                    Node node2 = document.importNode(ModelTransformationUtils.createElementFromString(string2), true);
                    node.appendChild(node2);
                }
            }
        }
        catch (Exception exception) {
            throw new XMLException("Couldn't generate new XML model", exception);
        }
    }

    private static Object applyXpath(String string, XPath xPath, Document document) throws XPathEvaluationException {
        Object object;
        try {
            XPathExpression xPathExpression = xPath.compile(string);
            object = xPathExpression.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
            throw new XPathEvaluationException("Could not evaluate XPath", xPathExpressionException);
        }
        return object;
    }

    static void addXMLelement(Document document, String string, String string2, XPath xPath) throws XMLException, XPathEvaluationException {
        Object object = ModelTransformationUtils.applyXpath(string2, xPath, document);
        NodeList nodeList = (NodeList)object;
        try {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = document.importNode(ModelTransformationUtils.createElementFromString(string), true);
                nodeList.item(i).appendChild(node);
            }
        }
        catch (Exception exception) {
            throw new XMLException("Couldn't generate new XML model", exception);
        }
    }

    private static Node createElementFromString(String string) throws SAXException, IOException, ParserConfigurationException {
        org.w3c.dom.Element element = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes("UTF-8"))).getDocumentElement();
        return element;
    }

    static String exportChangedXMLAsString(Document document) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult streamResult = new StreamResult(new StringWriter());
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, streamResult);
        String string = streamResult.getWriter().toString();
        return string;
    }

    static void applyAttributeChange(Document document, XPath xPath, Change change) throws XPathExpressionException {
        ChangeAttribute changeAttribute = (ChangeAttribute)change;
        XPathExpression xPathExpression = xPath.compile(change.getTargetXPath().getTargetAsString());
        Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
        NodeList nodeList = (NodeList)object;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodeList.item(i).setNodeValue(changeAttribute.getNewValue());
        }
    }

    static Document getXMLDocumentFromModelString(String string) throws ParserConfigurationException, UnsupportedEncodingException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
        outputStreamWriter.write(string);
        ((Writer)outputStreamWriter).close();
        byteArrayOutputStream.close();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        return document;
    }
}

