/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sedml.AbstractIdentifiableElement;
import org.sedml.Assert;
import org.sedml.Change;
import org.sedml.SEDMLElementFactory;
import org.sedml.SEDMLVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Model
extends AbstractIdentifiableElement {
    private String language = null;
    private String source = null;
    private List<Change> listOfChanges = new ArrayList<Change>();

    public Model(String string, String string2, String string3, String string4) {
        super(string, string2);
        if (SEDMLElementFactory.getInstance().isStrictCreation()) {
            Assert.checkNoNullArgs(string4);
            Assert.stringsNotEmpty(string4);
        }
        this.language = string3;
        this.source = string4;
    }

    public Model(Model model, String string) {
        this(string, model.getName(), model.getLanguage(), model.getSource());
    }

    public List<Change> getListOfChanges() {
        Collections.sort(this.listOfChanges, new Change.ChangeComparator());
        return Collections.unmodifiableList(this.listOfChanges);
    }

    public boolean hasChanges() {
        return this.listOfChanges.size() > 0;
    }

    public boolean addChange(Change change) {
        if (!this.listOfChanges.contains(change)) {
            return this.listOfChanges.add(change);
        }
        return false;
    }

    public boolean removeChange(Change change) {
        return this.listOfChanges.add(change);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSource() {
        return this.source;
    }

    public URI getSourceURI() throws URISyntaxException {
        return new URI(this.source);
    }

    public boolean isSourceURIRelative() {
        URI uRI = null;
        try {
            uRI = this.getSourceURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return uRI.getAuthority() == null && uRI.getFragment() == null && uRI.getHost() == null && uRI.getQuery() == null && uRI.getScheme() == null && uRI.getPath() != null;
    }

    public boolean isSourceValidURI() {
        try {
            new URI(this.getSource());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return true;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String toString() {
        return new StringBuffer().append("[Model] ").append("id: (").append(this.getId()).append("), ").append("name: (").append(this.getName()).append("), ").append("language: (").append(this.language).append("), ").append("src:").append(this.source).toString();
    }

    @Override
    public String getElementName() {
        return "model";
    }

    @Override
    public boolean accept(SEDMLVisitor sEDMLVisitor) {
        if (!sEDMLVisitor.visit(this)) {
            return false;
        }
        for (Change change : this.getListOfChanges()) {
            if (change.accept(sEDMLVisitor)) continue;
            return false;
        }
        return true;
    }
}

