/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jmathml.ASTNode;
import org.jmathml.ASTRootNode;
import org.jmathml.ASTSymbolFactory;
import org.jmathml.MathMLReader;
import org.jmathml.SymbolRegistry;
import org.jmathml.TextToASTNodeMathParser2;
import org.sedml.ArchiveComponents;
import org.sedml.BaseModelContent;
import org.sedml.IModelContent;
import org.sedml.SEDMLDocument;
import org.sedml.SEDMLElementFactory;
import org.sedml.SEDMLReader;
import org.sedml.SedML;
import org.sedml.SedMLError;
import org.sedml.XMLException;
import org.sedml.mathsymbols.SedMLSymbolFactory;
import org.sedml.validation.RawContentsSchemaValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Libsedml {
    private Libsedml() {
    }

    public static SEDMLDocument readDocument(File file) throws XMLException {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new XMLException("Could not read file", iOException);
        }
        String string = stringBuffer.toString();
        SEDMLDocument sEDMLDocument = Libsedml.readDocumentFromString(string);
        return sEDMLDocument;
    }

    public static boolean isSEDML(File file) {
        try {
            return Libsedml.isSEDML(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static boolean isSEDML(InputStream inputStream) {
        Document document = null;
        try {
            document = Libsedml.createDocument(inputStream);
        }
        catch (XMLException xMLException) {
            return false;
        }
        return "http://sed-ml.org/".equalsIgnoreCase(document.getRootElement().getNamespaceURI());
    }

    private static Document createDocument(InputStream inputStream) throws XMLException {
        Document document;
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            document = sAXBuilder.build(inputStream);
        }
        catch (JDOMException jDOMException) {
            throw new XMLException("Error reading file", (Exception)((Object)jDOMException));
        }
        catch (IOException iOException) {
            throw new XMLException("Error reading file", iOException);
        }
        return document;
    }

    public static String MathMLXMLToText(String string) {
        SymbolRegistry.getInstance().addSymbolFactory((ASTSymbolFactory)new SedMLSymbolFactory());
        String string2 = MathMLReader.MathMLXMLToText((String)string);
        if (Libsedml.hasExtraSurroundingParentheses(string2)) {
            return string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    private static boolean hasExtraSurroundingParentheses(String string) {
        return string.trim().lastIndexOf("(") == 0 && string.trim().indexOf(")") == string.length() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SEDMLDocument buildDocumentFromXMLTree(Document document, List<SedMLError> list) throws XMLException {
        Element element = document.getRootElement();
        SEDMLReader sEDMLReader = new SEDMLReader();
        try {
            SEDMLElementFactory.getInstance().setStrictCreation(false);
            SedML sedML = sEDMLReader.getSedDocument(element);
            SEDMLDocument sEDMLDocument = new SEDMLDocument(sedML, list);
            sEDMLDocument.validate();
            SEDMLDocument sEDMLDocument2 = sEDMLDocument;
            return sEDMLDocument2;
        }
        finally {
            SEDMLElementFactory.getInstance().setStrictCreation(true);
        }
    }

    public static SEDMLDocument createDocument() {
        return new SEDMLDocument();
    }

    public static byte[] writeSEDMLArchive(ArchiveComponents archiveComponents, String string) throws XMLException {
        ZipOutputStream zipOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            Object object;
            byteArrayOutputStream = new ByteArrayOutputStream();
            zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            for (IModelContent object22 : archiveComponents.getModelFiles()) {
                zipOutputStream.putNextEntry(new ZipEntry(object22.getName()));
                object = object22.getContents().getBytes();
                zipOutputStream.write((byte[])object);
            }
            zipOutputStream.putNextEntry(new ZipEntry(string + ".xml"));
            String string2 = archiveComponents.getSedmlDocument().writeDocumentToString();
            byte[] byArray = string2.getBytes("UTF-8");
            object = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            throw new XMLException("Error generating SED-ML archive file:", exception);
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static ArchiveComponents readSEDMLArchive(InputStream inputStream) throws XMLException {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        ArrayList<IModelContent> arrayList = new ArrayList<IModelContent>();
        SEDMLDocument sEDMLDocument = null;
        try {
            Object object;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                object = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                while ((n = zipInputStream.read(byArray)) != -1) {
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                }
                if (Libsedml.isSEDML(new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray()))) {
                    sEDMLDocument = Libsedml.readDocumentFromString(((ByteArrayOutputStream)object).toString());
                    continue;
                }
                BaseModelContent baseModelContent = new BaseModelContent(((ByteArrayOutputStream)object).toString(), zipEntry.getName());
                arrayList.add(baseModelContent);
            }
            object = new ArchiveComponents(arrayList, sEDMLDocument);
            return object;
        }
        catch (Exception exception) {
            throw new XMLException("Error reading archive", exception);
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SEDMLDocument readDocumentFromString(String string) throws XMLException {
        Document document;
        SAXBuilder sAXBuilder = new SAXBuilder();
        List<SedMLError> list = new RawContentsSchemaValidator(string).validate();
        try {
            document = sAXBuilder.build((Reader)new StringReader(string));
        }
        catch (JDOMException jDOMException) {
            throw new XMLException("Error reading file", (Exception)((Object)jDOMException));
        }
        catch (IOException iOException) {
            throw new XMLException("Error reading file", iOException);
        }
        SEDMLDocument sEDMLDocument = Libsedml.buildDocumentFromXMLTree(document, list);
        return sEDMLDocument;
    }

    public static File writeXMLStringToFile(String string, String string2, boolean bl) throws IOException {
        File file = new File(string2);
        OutputStreamWriter outputStreamWriter = null;
        outputStreamWriter = bl ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8") : new OutputStreamWriter(new FileOutputStream(file));
        outputStreamWriter.write(string);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        return file;
    }

    public static ASTNode parseFormulaString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ASTRootNode aSTRootNode = new ASTRootNode();
        new TextToASTNodeMathParser2().parseString(string, (ASTNode)aSTRootNode);
        return aSTRootNode;
    }
}

