/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jmathml.ASTNode;
import org.sedml.AbstractIdentifiableElement;
import org.sedml.Assert;
import org.sedml.IMathContainer;
import org.sedml.Parameter;
import org.sedml.SEDMLElementFactory;
import org.sedml.SEDMLVisitor;
import org.sedml.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataGenerator
extends AbstractIdentifiableElement
implements IMathContainer {
    private ASTNode math = null;
    private ArrayList<Variable> listOfVariables = new ArrayList();
    private ArrayList<Parameter> listOfParameters = new ArrayList();

    public DataGenerator(String string, String string2, ASTNode aSTNode) {
        super(string, string2);
        if (SEDMLElementFactory.getInstance().isStrictCreation()) {
            Assert.checkNoNullArgs(aSTNode);
        }
        this.math = aSTNode;
    }

    DataGenerator(String string, String string2) {
        super(string, string2);
    }

    public String toString() {
        return "DataGenerator [math=" + this.math + ", name=" + this.getName() + ", getId()=" + this.getId() + "]";
    }

    public List<Variable> getListOfVariables() {
        return Collections.unmodifiableList(this.listOfVariables);
    }

    public boolean addVariable(Variable variable) {
        if (!this.listOfVariables.contains(variable)) {
            return this.listOfVariables.add(variable);
        }
        return false;
    }

    public boolean removeVariable(Variable variable) {
        return this.listOfVariables.remove(variable);
    }

    public List<Parameter> getListOfParameters() {
        return Collections.unmodifiableList(this.listOfParameters);
    }

    public boolean addParameter(Parameter parameter) {
        if (!this.listOfParameters.contains(parameter)) {
            return this.listOfParameters.add(parameter);
        }
        return false;
    }

    public boolean removeParameter(Parameter parameter) {
        return this.listOfParameters.remove(parameter);
    }

    void setMathML(ASTNode aSTNode) {
        this.math = aSTNode;
    }

    @Override
    public ASTNode getMath() {
        return this.math;
    }

    @Override
    public String getElementName() {
        return "dataGenerator";
    }

    @Override
    public boolean accept(SEDMLVisitor sEDMLVisitor) {
        if (sEDMLVisitor.visit(this)) {
            for (Variable abstractIdentifiableElement : this.getListOfVariables()) {
                if (abstractIdentifiableElement.accept(sEDMLVisitor)) continue;
                return false;
            }
            for (Parameter parameter : this.getListOfParameters()) {
                if (parameter.accept(sEDMLVisitor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

