/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.ArrayList;
import java.util.List;
import org.jmathml.ASTNode;
import org.sedml.Change;
import org.sedml.IMathContainer;
import org.sedml.Parameter;
import org.sedml.SEDMLVisitor;
import org.sedml.Variable;
import org.sedml.XPathTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComputeChange
extends Change
implements IMathContainer {
    private ASTNode math = null;
    private List<Variable> listOfVariables;
    private List<Parameter> listOfParameters;

    public ComputeChange(XPathTarget xPathTarget, ASTNode aSTNode) {
        super(xPathTarget);
        this.math = aSTNode;
        this.listOfVariables = new ArrayList<Variable>();
        this.listOfParameters = new ArrayList<Parameter>();
    }

    @Override
    public String getChangeKind() {
        return "ComputeChange";
    }

    @Override
    public ASTNode getMath() {
        return this.math;
    }

    @Override
    public boolean accept(SEDMLVisitor sEDMLVisitor) {
        if (sEDMLVisitor.visit(this)) {
            for (Variable abstractIdentifiableElement : this.getListOfVariables()) {
                if (abstractIdentifiableElement.accept(sEDMLVisitor)) continue;
                return false;
            }
            for (Parameter parameter : this.getListOfParameters()) {
                if (parameter.accept(sEDMLVisitor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<Variable> getListOfVariables() {
        return this.listOfVariables;
    }

    public String toString() {
        return "ComputeChange [math=" + this.math + ", getTarget()=" + this.getTargetXPath() + "]";
    }

    void setListOfVariables(List<Variable> list) {
        this.listOfVariables = list;
    }

    void setListOfParameters(List<Parameter> list) {
        this.listOfParameters = list;
    }

    public List<Parameter> getListOfParameters() {
        return this.listOfParameters;
    }

    public boolean addParameter(Parameter parameter) {
        return this.listOfParameters.add(parameter);
    }

    public boolean addVariable(Variable variable) {
        return this.listOfVariables.add(variable);
    }

    @Override
    public String getId() {
        return "ComputeChange";
    }

    @Override
    public String getElementName() {
        return "computeChange";
    }
}

