/*
 * Decompiled with CFR 0.152.
 */
package org.sedml;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.sedml.Assert;
import org.sedml.SEDBase;
import org.sedml.SEDMLElementFactory;
import org.sedml.XPathTarget;

public abstract class Change
extends SEDBase {
    private XPathTarget target = null;

    public Change(XPathTarget xPathTarget) {
        if (SEDMLElementFactory.getInstance().isStrictCreation()) {
            Assert.checkNoNullArgs(xPathTarget);
        }
        this.target = xPathTarget;
    }

    public final XPathTarget getTargetXPath() {
        return this.target;
    }

    public abstract String getChangeKind();

    public boolean isChangeAttribute() {
        return "ChangeAttribute".equals(this.getChangeKind());
    }

    public boolean isChangeXML() {
        return "ChangeXML".equals(this.getChangeKind());
    }

    public boolean isAddXML() {
        return "AddXML".equals(this.getChangeKind());
    }

    public boolean isRemoveXML() {
        return "RemoveXML".equals(this.getChangeKind());
    }

    public boolean isComputeChange() {
        return "ComputeChange".equals(this.getChangeKind());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChangeComparator
    implements Comparator<Change> {
        static Map<String, Integer> changeKindOrder = new HashMap<String, Integer>();

        ChangeComparator() {
        }

        @Override
        public int compare(Change change, Change change2) {
            return changeKindOrder.get(change.getChangeKind()).compareTo(changeKindOrder.get(change2.getChangeKind()));
        }

        static {
            changeKindOrder.put("ChangeAttribute", 1);
            changeKindOrder.put("ChangeXML", 2);
            changeKindOrder.put("AddXML", 3);
            changeKindOrder.put("RemoveXML", 4);
            changeKindOrder.put("ComputeChange", 5);
        }
    }
}

